package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;
import com.zehong.system.domain.TConGasProInc;
import org.apache.ibatis.annotations.Param;

/**
 * 第三方施工-涉气第三方施工意外事件Mapper接口
 * 
 * @author zehong
 * @date 2024-06-27
 */
public interface TConGasProIncMapper 
{
    /**
     * 查询第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 第三方施工-涉气第三方施工意外事件
     */
    public TConGasProInc selectTConGasProIncById(Long fConGasProIncId);

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件集合
     */
    public List<TConGasProInc> selectTConGasProIncList(TConGasProInc tConGasProInc);

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表 - 导出
     *
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件集合
     */
    public List<TConGasProInc> exportTConGasProInforList(TConGasProInc tConGasProInc);
    /**
     * 新增第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    public int insertTConGasProInc(TConGasProInc tConGasProInc);

    /**
     * 修改第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    public int updateTConGasProInc(TConGasProInc tConGasProInc);

    /**
     *
     * 根据id修改 企业端上传状态*/
    public int updateEntUploadStateById(@Param("state")  String state, @Param("entUploadTime") Date entUploadTime,
                                        @Param("fConGasProIncId") Long fConGasProIncId);
    /**
     * 删除第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 结果
     */
    public int deleteTConGasProIncById(Long fConGasProIncId);

    /**
     * 批量删除第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTConGasProIncByIds(Long[] fConGasProIncIds);
}
