package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.domain.dto.TComplainDealDTO;
import com.zehong.system.domain.vo.HomepageVo;
import org.apache.ibatis.annotations.Param;

/**
 * 投诉处置Mapper接口
 * 
 * @author zehong
 * @date 2022-02-15
 */
public interface TComplainDealMapper 
{
    /**
     * 查询投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 投诉处置
     */
    public TComplainDeal selectTComplainDealById(Long complainDealId);

    /**
     * 查询投诉处置列表
     * 
     * @param tComplainDeal 投诉处置
     * @return 投诉处置集合
     */
    public List<TComplainDeal> selectTComplainDealList(TComplainDeal tComplainDeal);

    /**
     * 投诉处置统计
     *
     * @return 投诉处置统计
     */
    public HomepageVo countTComplainDeal();

    /**
     * 新增投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int insertTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 查询所有归档的，并且没删除的
     * @return
     */
    public List<TComplainDeal> queryAllByNotDelete();

    /**
     * 查询所有归档的，并且没删除的，看是否有时间范围查询
     * @return
     */
    public List<TComplainDealDTO> queryAllByNotDeleteAndCreateTime(@Param("startOfMonth") Date startOfMonth,
                                                                   @Param("endOfMonth") Date endOfMonth,
                                                                   @Param("complaintCategory") String complaintCategory);
    /**
     * 修改投诉处置
     *
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int clearTComplainDeal(TComplainDeal tComplainDeal);
    /**
     * 修改投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int updateTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 删除投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 结果
     */
    public int deleteTComplainDealById(Long complainDealId);

    /**
     * 批量删除投诉处置
     * 
     * @param complainDealIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTComplainDealByIds(Long[] complainDealIds);

    /**
     * 查询公司下用户
     * @param enterproseId
     * @return
     */
    public List<Map<String,Object>> selectUserByenterproseId(@Param("enterproseId")String enterproseId);
}
