package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 带有村 和 安全装置的 燃气用户 VO
 */
@Data
public class TDetectorUserVillageSafetyDeviceInfoVo {

    /**
     * 燃气用户ID
     */
    private Long userId;

    /**
     * 用户类型 1=居民用户，2=工商业用户，4=餐饮用户
     */
    private String userType;

    /**
     * 燃气类型(0-天然气，1-液化气)
     */
    private String gasType;

    /**
     * 燃气用户名称
     */
    private String nickName;

    /**
     * 燃气用户电话
     */
    private String phone;

    /**
     * 燃气用户地址
     */
    private String address;

    /**
     * 用户的 经纬度
     */
    private String userLongitude;

    /**
     * 用户的 经纬度
     */
    private String userLatitude;


    /**
     * 村庄id
     */
    private Long villageId;

    /**
     * 村庄名称
     */
    private String villageName;

    /**
     * 村庄地址
     */
    private String regionName;

    /**
     * 村的 经纬度
     */
    private String longitude;

    /**
     * 村的 经纬度
     */
    private String latitude;

    /**
     * 安全装置 id
     */
    private Long gasUserSafetyDeviceId;

    /**
     * 编号
     */
    private String iotNo;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 设备介质
     */
    private String detctionMedium;

    /**
     * 设备安装时间
     */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    private Date deviceInstallTime;

    /**
     * 图标类型默认 61
     */
    private String iconType;
}
