package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 入户安检对象 t_work_task_inspect
 * 
 * @author zehong
 * @date 2023-09-15
 */
public class TWorkTaskInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long inspectId;

    /** 任务id */
    @Excel(name = "任务id")
    private Long taskId;

    /** 经度 */
    @Excel(name = "经度")
    private String longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private String latitude;

    /** 检查单JSON */
    @Excel(name = "检查单JSON")
    private String inspectContent;

    /** 安检人id */
    @Excel(name = "安检人id")
    private Long memberId;

    /** 业主id */
    @Excel(name = "业主id")
    private Long receiveId;

    /** 0未检测 1已检测 */
    @Excel(name = "0未检测 1已检测")
    private Integer status;

    /** 0否 1是 */
    @Excel(name = "0否 1是")
    private Integer isReport;

    private String memberName;
    private String nickName;
    private String address;
    private String username;

    private String taskTitle;

    private Long createEnterpriseId;

    private Integer taskStatus;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setInspectId(Long inspectId)
    {
        this.inspectId = inspectId;
    }

    public Long getInspectId() 
    {
        return inspectId;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setLongitude(String longitude) 
    {
        this.longitude = longitude;
    }

    public String getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(String latitude) 
    {
        this.latitude = latitude;
    }

    public String getLatitude() 
    {
        return latitude;
    }
    public void setInspectContent(String inspectContent) 
    {
        this.inspectContent = inspectContent;
    }

    public String getInspectContent() 
    {
        return inspectContent;
    }
    public void setMemberId(Long memberId) 
    {
        this.memberId = memberId;
    }

    public Long getMemberId() 
    {
        return memberId;
    }
    public void setReceiveId(Long receiveId) 
    {
        this.receiveId = receiveId;
    }

    public Long getReceiveId() 
    {
        return receiveId;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setIsReport(Integer isReport) 
    {
        this.isReport = isReport;
    }

    public Integer getIsReport() 
    {
        return isReport;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String username) {
        this.nickName = username;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTaskTitle() {
        return taskTitle;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public Long getCreateEnterpriseId() {
        return createEnterpriseId;
    }

    public void setCreateEnterpriseId(Long createEnterpriseId) {
        this.createEnterpriseId = createEnterpriseId;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("inspectId", getInspectId())
            .append("taskId", getTaskId())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("inspectContent", getInspectContent())
            .append("memberId", getMemberId())
            .append("receiveId", getReceiveId())
            .append("status", getStatus())
            .append("isReport", getIsReport())
            .append("createTime", getCreateTime())
            .toString();
    }
}
