package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * 燃气车辆信息对象 t_vehicle_info
 *
 * @author zehong
 * @date 2023-08-16
 */
public class TVehicleInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车辆id */
    private Long vehicleId;

    /**
     * 车辆编号
     */
    @Excel(name = "车辆编号")
    private String carNumber;

    /** 车牌号 */
    @Excel(name = "车牌号")
    private String carNum;

    /** 品牌型号 */
    @Excel(name = "品牌型号")
    private String brandModel;

    /** 车辆类型: 1.罐车 2.卡车 */
    @Excel(name = "车辆类型: 1.罐车 2.卡车")
    private String vehicleType;

    /** 车辆载重 */
    @Excel(name = "车辆载重")
    private String vehicleLoad;

    /** 车辆大小 */
    @Excel(name = "车辆大小")
    private String vehicleSize;

    /** 车辆限乘 */
    @Excel(name = "车辆限乘")
    private String vehicleLimt;

    /** 车辆检测信息 */
    @Excel(name = "车辆检测信息")
    private String vehicleInspect;

    /** 所属企业 */
    @Excel(name = "所属企业")
    private String beyondEnterpriseId;

    /** 责任人 */
    @Excel(name = "责任人")
    private String personLiable;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /**
     * 使用状态   0未使用   1使用中
     */
    private String onState;

    /**
     * 储配站名称
     */
    private String siteStationName;

    /** 车辆使用人 */
    private Long vehicleUserId;


    /**
     * 使用人姓名
     */
    private String name;

    /**
     * 储配站id
     */
    private Long stationId;

    /**
     * 储配站名称
     */
    private String stationName;


    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public Long getStationId() {
        return stationId;
    }

    public void setStationId(Long stationId) {
        this.stationId = stationId;
    }

    public Long getVehicleUserId() {
        return vehicleUserId;
    }

    public void setVehicleUserId(Long vehicleUserId) {
        this.vehicleUserId = vehicleUserId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private BigDecimal longitude;

    private BigDecimal latitude;

    private String beyondEnterpriseName;

    public String getOnState() {
        return onState;
    }

    public void setOnState(String onState) {
        this.onState = onState;
    }

    public String getCarNumber() {
        return carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }

    public String getSiteStationName() {
        return siteStationName;
    }

    public void setSiteStationName(String siteStationName) {
        this.siteStationName = siteStationName;
    }

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setVehicleId(Long vehicleId)
    {
        this.vehicleId = vehicleId;
    }

    public Long getVehicleId()
    {
        return vehicleId;
    }
    public void setCarNum(String carNum)
    {
        this.carNum = carNum;
    }

    public String getCarNum()
    {
        return carNum;
    }
    public void setBrandModel(String brandModel)
    {
        this.brandModel = brandModel;
    }

    public String getBrandModel()
    {
        return brandModel;
    }
    public void setVehicleType(String vehicleType)
    {
        this.vehicleType = vehicleType;
    }

    public String getVehicleType()
    {
        return vehicleType;
    }
    public void setVehicleLoad(String vehicleLoad)
    {
        this.vehicleLoad = vehicleLoad;
    }

    public String getVehicleLoad()
    {
        return vehicleLoad;
    }
    public void setVehicleSize(String vehicleSize)
    {
        this.vehicleSize = vehicleSize;
    }

    public String getVehicleSize()
    {
        return vehicleSize;
    }
    public void setVehicleLimt(String vehicleLimt)
    {
        this.vehicleLimt = vehicleLimt;
    }

    public String getVehicleLimt()
    {
        return vehicleLimt;
    }
    public void setVehicleInspect(String vehicleInspect)
    {
        this.vehicleInspect = vehicleInspect;
    }

    public String getVehicleInspect()
    {
        return vehicleInspect;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public void setPersonLiable(String personLiable)
    {
        this.personLiable = personLiable;
    }

    public String getPersonLiable()
    {
        return personLiable;
    }
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone()
    {
        return phone;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TVehicleInfo{" +
                "vehicleId=" + vehicleId +
                ", carNumber='" + carNumber + '\'' +
                ", carNum='" + carNum + '\'' +
                ", brandModel='" + brandModel + '\'' +
                ", vehicleType='" + vehicleType + '\'' +
                ", vehicleLoad='" + vehicleLoad + '\'' +
                ", vehicleSize='" + vehicleSize + '\'' +
                ", vehicleLimt='" + vehicleLimt + '\'' +
                ", vehicleInspect='" + vehicleInspect + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", personLiable='" + personLiable + '\'' +
                ", phone='" + phone + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", onState='" + onState + '\'' +
                ", siteStationName='" + siteStationName + '\'' +
                ", vehicleUserId=" + vehicleUserId +
                ", name='" + name + '\'' +
                ", stationId=" + stationId +
                ", stationName='" + stationName + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                '}';
    }
}
