package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 培训管理对象 t_train_manage
 * 
 * @author zehong
 * @date 2023-04-21
 */
public class TTrainManage extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 培训管理主键 */
    private Long trainManageId;

    /** 课程名称 */
    @Excel(name = "课程名称")
    private String lessonName;

    /** 培训时长/秒 */
    @Excel(name = "培训时长/秒")
    private Integer trainDuration;

    /** 培训开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "培训开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date trainStartTime;

    /** 培训结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "培训结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date trainEndTime;

    /** 课程内容 */
    @Excel(name = "课程内容")
    private String lessonContent;

    /** 视频地址 */
    @Excel(name = "视频地址")
    private String videoUrl;

    /** 附件地址 */
    @Excel(name = "附件地址")
    private String annexUrl;

    /** 培训状态：0 待发布, 1 已发布 */
    @Excel(name = "培训状态：0 待发布, 1 已发布")
    private String trainStatus;

    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "发布时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date publishTime;

    /** 删除标志（0正常，1删除） */
    private String isDel;

    /**培训人员*/
    private List<TTrainPerson> tTrainPersonList;

    private String isFinish;

    public void setTrainManageId(Long trainManageId) 
    {
        this.trainManageId = trainManageId;
    }

    public Long getTrainManageId() 
    {
        return trainManageId;
    }
    public void setLessonName(String lessonName) 
    {
        this.lessonName = lessonName;
    }

    public String getLessonName() 
    {
        return lessonName;
    }
    public void setTrainDuration(Integer trainDuration) 
    {
        this.trainDuration = trainDuration;
    }

    public Integer getTrainDuration() 
    {
        return trainDuration;
    }
    public void setTrainStartTime(Date trainStartTime) 
    {
        this.trainStartTime = trainStartTime;
    }

    public Date getTrainStartTime() 
    {
        return trainStartTime;
    }
    public void setTrainEndTime(Date trainEndTime) 
    {
        this.trainEndTime = trainEndTime;
    }

    public Date getTrainEndTime() 
    {
        return trainEndTime;
    }
    public void setLessonContent(String lessonContent) 
    {
        this.lessonContent = lessonContent;
    }

    public String getLessonContent() 
    {
        return lessonContent;
    }
    public void setVideoUrl(String videoUrl) 
    {
        this.videoUrl = videoUrl;
    }

    public String getVideoUrl() 
    {
        return videoUrl;
    }
    public void setAnnexUrl(String annexUrl) 
    {
        this.annexUrl = annexUrl;
    }

    public String getAnnexUrl() 
    {
        return annexUrl;
    }
    public void setTrainStatus(String trainStatus) 
    {
        this.trainStatus = trainStatus;
    }

    public String getTrainStatus() 
    {
        return trainStatus;
    }
    public void setPublishTime(Date publishTime)
    {
        this.publishTime = publishTime;
    }

    public Date getPublishTime()
    {
        return publishTime;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public List<TTrainPerson> gettTrainPersonList() {
        return tTrainPersonList;
    }

    public void settTrainPersonList(List<TTrainPerson> tTrainPersonList) {
        this.tTrainPersonList = tTrainPersonList;
    }

    public String getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(String isFinish) {
        this.isFinish = isFinish;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("trainManageId", getTrainManageId())
            .append("lessonName", getLessonName())
            .append("trainDuration", getTrainDuration())
            .append("trainStartTime", getTrainStartTime())
            .append("trainEndTime", getTrainEndTime())
            .append("lessonContent", getLessonContent())
            .append("videoUrl", getVideoUrl())
            .append("annexUrl", getAnnexUrl())
            .append("trainStatus", getTrainStatus())
            .append("publishTime", getPublishTime())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("isDel", getIsDel())
            .toString();
    }
}
