package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 重要风险点管控对象 t_risk_dev_maj_infor
 * 
 * @author zehong
 * @date 2024-07-01
 */
public class TRiskDevMajInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fRiskDevMajInforId;

    /** 重要风险点编码，涉及企业的11位编码 + 6 位顺序码 */
    @Excel(name = "重要风险点编码")
    private String fRiskCode;

    /** 重要风险点名称，场所名称或描述 */
    @Excel(name = "重要风险点名称")
    private String fRiskName;

    /** 重要风险点涉及燃气企业编码 */
    private String fCompanyId;

    /**
     * 企业名称
     */
    @Excel(name = "燃气企业")
    private String companyName;

    /** 县级行政区ID */
    private Long fRegionId;

    /**
     * 行政区名称
     */
    @Excel(name = "县级行政区")
    private String regionName;

    /** 重要风险点类型，1 密闭空间，2 人员密集场

            所，3 穿越铁路、河流、地铁、隧道等，4 距

            离铁路、城市主干道较近，5 城市易涝点，泄

            洪区等 */
    @Excel(name = "重要风险点类型",dictType = "t_risk_type")
    private Long fRiskType;

    /** 所在位置地址描述 */
    @Excel(name = "所在位置地址描述")
    private String fRiskPlaceDetail;

    /** 在GIS地图上的经度 */
    @Excel(name = "在GIS地图上的经度")
    private String fLon;

    /** 在GIS地图上的围堵 */
    @Excel(name = "在GIS地图上的围堵")
    private String fLat;

    /** 风险构成 */
    @Excel(name = "风险构成")
    private String fRiskStructure;

    /** 风险管控 */
    @Excel(name = "风险管控")
    private String fRiskControlMeasures;

    /** 备注 */
    @Excel(name = "备注")
    private String fRemark;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    private String fUpdateTime;

    /**
     * 企业端上传状态 0-未上传，1-已上传,Excel 企业和政府通用
     */
    @Excel(name = "上报状态",readConverterExp = "1=已上报,0=未上报")
    private String entUploadState;

    /**
     * 企业端上传时间 Excel 企业和政府通用
     */
    @Excel(name = "上报时间",dateFormat = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date entUploadTime;

    /**
     * 政府端上传 状态
     */
    @Excel(name = "上报省厅状态",readConverterExp = "1=已上报,0=未上报")
    private String govUploadState;

    /**
     * 政府端上传 时间
     */
    @Excel(name = "上报省厅时间",dateFormat = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date govUploadTime;

    public void updateFields() {
        this.entUploadState = govUploadState;
        if (govUploadTime != null) {
            this.entUploadTime =  govUploadTime;
        } else {
            this.entUploadTime = null;
        }
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setfRiskDevMajInforId(Long fRiskDevMajInforId)
    {
        this.fRiskDevMajInforId = fRiskDevMajInforId;
    }

    public Long getfRiskDevMajInforId() 
    {
        return fRiskDevMajInforId;
    }
    public void setfRiskCode(String fRiskCode) 
    {
        this.fRiskCode = fRiskCode;
    }

    public String getfRiskCode() 
    {
        return fRiskCode;
    }
    public void setfRiskName(String fRiskName) 
    {
        this.fRiskName = fRiskName;
    }

    public String getfRiskName() 
    {
        return fRiskName;
    }
    public void setfCompanyId(String fCompanyId) 
    {
        this.fCompanyId = fCompanyId;
    }

    public String getfCompanyId() 
    {
        return fCompanyId;
    }
    public void setfRegionId(Long fRegionId)
    {
        this.fRegionId = fRegionId;
    }

    public Long getfRegionId()
    {
        return fRegionId;
    }
    public void setfRiskType(Long fRiskType) 
    {
        this.fRiskType = fRiskType;
    }

    public Long getfRiskType() 
    {
        return fRiskType;
    }
    public void setfRiskPlaceDetail(String fRiskPlaceDetail) 
    {
        this.fRiskPlaceDetail = fRiskPlaceDetail;
    }

    public String getfRiskPlaceDetail() 
    {
        return fRiskPlaceDetail;
    }
    public void setfLon(String fLon) 
    {
        this.fLon = fLon;
    }

    public String getfLon() 
    {
        return fLon;
    }
    public void setfLat(String fLat) 
    {
        this.fLat = fLat;
    }

    public String getfLat() 
    {
        return fLat;
    }
    public void setfRiskStructure(String fRiskStructure) 
    {
        this.fRiskStructure = fRiskStructure;
    }

    public String getfRiskStructure() 
    {
        return fRiskStructure;
    }
    public void setfRiskControlMeasures(String fRiskControlMeasures) 
    {
        this.fRiskControlMeasures = fRiskControlMeasures;
    }

    public String getfRiskControlMeasures() 
    {
        return fRiskControlMeasures;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }

    public String getEntUploadState() {
        return entUploadState;
    }

    public void setEntUploadState(String entUploadState) {
        this.entUploadState = entUploadState;
    }

    public Date getEntUploadTime() {
        return entUploadTime;
    }

    public void setEntUploadTime(Date entUploadTime) {
        this.entUploadTime = entUploadTime;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fRiskDevMajInforId", getfRiskDevMajInforId())
            .append("fRiskCode", getfRiskCode())
            .append("fRiskName", getfRiskName())
            .append("fCompanyId", getfCompanyId())
            .append("fRegionId", getfRegionId())
            .append("fRiskType", getfRiskType())
            .append("fRiskPlaceDetail", getfRiskPlaceDetail())
            .append("fLon", getfLon())
            .append("fLat", getfLat())
            .append("fRiskStructure", getfRiskStructure())
            .append("fRiskControlMeasures", getfRiskControlMeasures())
            .append("fRemark", getfRemark())
            .append("fUpdateTime", getfUpdateTime())
            .toString();
    }
}
