package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管道信息对象 t_pipe_info
 *
 * @author zehong
 * @date 2022-02-09
 */
public class TPipeInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 管道id */
    private Long pipeId;

    /** 管道长度 */
    @Excel(name = "管道长度(米)")
    private BigDecimal pipeLength;

    /** 管径 */
    @Excel(name = "管径(厘米)")
    private String pipeDiameter;

    /** 压力 */
    @Excel(name = "压力")
    private String pipePressure;

    /** 材质 */
    @Excel(name = "材质")
    private String pipeMaterial;

    /** 管道地址 */
    private String pipeAddr;

    /** 埋深 */
    @Excel(name = "埋深")
    private String buriedDepth;

    /** 走向 */
    @Excel(name = "走向")
    private String pipeTrend;

    /** 建设年代 */
    @Excel(name = "建设年代")
    private String buildDate;

    /** 建设单位 */
    @Excel(name = "建设单位")
    private String buildUnit;

    /**人员类型*/
    private String peopleOccupation;

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    /** 坐标 */
    @Excel(name = "坐标")
    private String coordinates;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /**
     * 管道名称
     */
    private String pipeName;

    /**
     * 详细地址
     */
    private String detaildAddress;

    /**
     * 行业主管部门
     */
    private String indRegAuth;

    /**
     * 行业主管部门负责人
     */
    private String indRegAuthPer;

    /**
     * 属地负责人电话
     */
    private String indRegAuthPerCon;

    /**
     * 重点部位燃气具使用情况
     */
    private String keyAreasGasUsage;

    /**
     * 所属燃气公司
     */
    private String affGasCom;

    /**
     * 所属燃气公司安检人员
     */
    private String affGasComSecPer;

    /**
     * 燃气公司安检人员电话
     */
    private String affGasComSecPerCon;

    /**
     * 安检时间
     */
    private String secCheckTime;

    /**
     * 单位燃气用户负责人
     */
    private String unitGasUserRes;

    /**
     * 单位燃气用户负责人电话
     */
    private String unitGasUserResCon;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getPeopleOccupation() {
        return peopleOccupation;
    }

    public void setPeopleOccupation(String peopleOccupation) {
        this.peopleOccupation = peopleOccupation;
    }

    public void setPipeId(Long pipeId)
    {
        this.pipeId = pipeId;
    }

    public Long getPipeId()
    {
        return pipeId;
    }
    public void setPipeLength(BigDecimal pipeLength)
    {
        this.pipeLength = pipeLength;
    }

    public BigDecimal getPipeLength() {
        return pipeLength;
    }

    public String getPipeDiameter() {
        return pipeDiameter;
    }

    public void setPipeDiameter(String pipeDiameter) {
        this.pipeDiameter = pipeDiameter;
    }

    public String getPipePressure() {
        return pipePressure;
    }

    public void setPipePressure(String pipePressure) {
        this.pipePressure = pipePressure;
    }

    public String getPipeMaterial() {
        return pipeMaterial;
    }

    public void setPipeMaterial(String pipeMaterial) {
        this.pipeMaterial = pipeMaterial;
    }

    public String getPipeAddr() {
        return pipeAddr;
    }

    public void setPipeAddr(String pipeAddr) {
        this.pipeAddr = pipeAddr;
    }

    public String getBuriedDepth() {
        return buriedDepth;
    }

    public void setBuriedDepth(String buriedDepth) {
        this.buriedDepth = buriedDepth;
    }

    public void setPipeTrend(String pipeTrend)
    {
        this.pipeTrend = pipeTrend;
    }

    public String getPipeTrend()
    {
        return pipeTrend;
    }
    public void setBuildDate(String buildDate)
    {
        this.buildDate = buildDate;
    }

    public String getBuildDate()
    {
        return buildDate;
    }
    public void setBuildUnit(String buildUnit)
    {
        this.buildUnit = buildUnit;
    }

    public String getBuildUnit()
    {
        return buildUnit;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }
    public void setCoordinates(String coordinates)
    {
        this.coordinates = coordinates;
    }

    public String getCoordinates()
    {
        return coordinates;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    public String getPipeName() {
        return pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public String getDetaildAddress() {
        return detaildAddress;
    }

    public void setDetaildAddress(String detaildAddress) {
        this.detaildAddress = detaildAddress;
    }

    public String getIndRegAuth() {
        return indRegAuth;
    }

    public void setIndRegAuth(String indRegAuth) {
        this.indRegAuth = indRegAuth;
    }

    public String getIndRegAuthPer() {
        return indRegAuthPer;
    }

    public void setIndRegAuthPer(String indRegAuthPer) {
        this.indRegAuthPer = indRegAuthPer;
    }

    public String getIndRegAuthPerCon() {
        return indRegAuthPerCon;
    }

    public void setIndRegAuthPerCon(String indRegAuthPerCon) {
        this.indRegAuthPerCon = indRegAuthPerCon;
    }

    public String getKeyAreasGasUsage() {
        return keyAreasGasUsage;
    }

    public void setKeyAreasGasUsage(String keyAreasGasUsage) {
        this.keyAreasGasUsage = keyAreasGasUsage;
    }

    public String getAffGasCom() {
        return affGasCom;
    }

    public void setAffGasCom(String affGasCom) {
        this.affGasCom = affGasCom;
    }

    public String getAffGasComSecPer() {
        return affGasComSecPer;
    }

    public void setAffGasComSecPer(String affGasComSecPer) {
        this.affGasComSecPer = affGasComSecPer;
    }

    public String getAffGasComSecPerCon() {
        return affGasComSecPerCon;
    }

    public void setAffGasComSecPerCon(String affGasComSecPerCon) {
        this.affGasComSecPerCon = affGasComSecPerCon;
    }

    public String getSecCheckTime() {
        return secCheckTime;
    }

    public void setSecCheckTime(String secCheckTime) {
        this.secCheckTime = secCheckTime;
    }

    public String getUnitGasUserRes() {
        return unitGasUserRes;
    }

    public void setUnitGasUserRes(String unitGasUserRes) {
        this.unitGasUserRes = unitGasUserRes;
    }

    public String getUnitGasUserResCon() {
        return unitGasUserResCon;
    }

    public void setUnitGasUserResCon(String unitGasUserResCon) {
        this.unitGasUserResCon = unitGasUserResCon;
    }

    @Override
    public String toString() {
        return "TPipeInfo{" +
                "pipeId=" + pipeId +
                ", pipeLength=" + pipeLength +
                ", pipeDiameter=" + pipeDiameter +
                ", pipePressure=" + pipePressure +
                ", pipeMaterial='" + pipeMaterial + '\'' +
                ", pipeAddr='" + pipeAddr + '\'' +
                ", buriedDepth=" + buriedDepth +
                ", pipeTrend='" + pipeTrend + '\'' +
                ", buildDate='" + buildDate + '\'' +
                ", buildUnit='" + buildUnit + '\'' +
                ", peopleOccupation='" + peopleOccupation + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                ", coordinates='" + coordinates + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
