package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Objects;

/**
 * 液化石油车辆信息对象 t_lpg_vehicle_info
 * 
 * @author zehong
 * @date 2024-07-19
 */
public class TLpgVehicleInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车辆主键 */
    private Long vehicleId;

    /**
     * 燃气企业id
     */
    private String enterpriseId;

    /**
     * 燃气企业
     */
    @Excel(name = "燃气企业")
    private String enterpriseName;

    /** 储配站 */
    @Excel(name = "储配站")
    private String stationName;

    /** 车辆编号 */
    @Excel(name = "车辆编号")
    private String carNumber;

    /** 企业ID */
    //@Excel(name = "企业ID")
    private Long beyondEnterpriseId;

    /** 代码 */
    @Excel(name = "代码")
    private String vehicleCode;

    /** 车牌 */
    @Excel(name = "车牌")
    private String carNum;

    /** 品牌型号 */
    @Excel(name = "品牌型号")
    private String brandModel;

    /** 车辆类型: 1.罐车 2.卡车 */
    @Excel(name = "车辆类型,1-罐车,2-卡车")
    private String vehicleType;

    /** 车辆载重 */
    @Excel(name = "车辆载重")
    private String vehicleLoad;

    /** 车辆大小 */
    @Excel(name = "车辆大小")
    private String vehicleSize;

    /** 车辆限乘 */
    @Excel(name = "车辆限乘")
    private String vehicleLimt;

    /** 车辆检查信息 */
    @Excel(name = "车辆检查信息")
    private String vehicleInspect;

    /** 责任人 */
    @Excel(name = "责任人")
    private String personLiable;

    /** 使用状态   0未使用   1使用中 */
    @Excel(name = "使用状态,0-未使用,1-使用中")
    private String onState;

    /** 使用人 */
    @Excel(name = "使用人")
    private String vehicleUser;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 是否删除(0正常，1删除) */
    //@Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public void setVehicleId(Long vehicleId)
    {
        this.vehicleId = vehicleId;
    }

    public Long getVehicleId() 
    {
        return vehicleId;
    }
    public void setStationName(String stationName) 
    {
        this.stationName = stationName;
    }

    public String getStationName() 
    {
        return stationName;
    }
    public void setCarNumber(String carNumber) 
    {
        this.carNumber = carNumber;
    }

    public String getCarNumber() 
    {
        return carNumber;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setVehicleCode(String vehicleCode) 
    {
        this.vehicleCode = vehicleCode;
    }

    public String getVehicleCode() 
    {
        return vehicleCode;
    }
    public void setCarNum(String carNum) 
    {
        this.carNum = carNum;
    }

    public String getCarNum() 
    {
        return carNum;
    }
    public void setBrandModel(String brandModel) 
    {
        this.brandModel = brandModel;
    }

    public String getBrandModel() 
    {
        return brandModel;
    }
    public void setVehicleType(String vehicleType) 
    {
        this.vehicleType = vehicleType;
    }

    public String getVehicleType() 
    {
        return vehicleType;
    }
    public void setVehicleLoad(String vehicleLoad) 
    {
        this.vehicleLoad = vehicleLoad;
    }

    public String getVehicleLoad() 
    {
        return vehicleLoad;
    }
    public void setVehicleSize(String vehicleSize) 
    {
        this.vehicleSize = vehicleSize;
    }

    public String getVehicleSize() 
    {
        return vehicleSize;
    }
    public void setVehicleLimt(String vehicleLimt) 
    {
        this.vehicleLimt = vehicleLimt;
    }

    public String getVehicleLimt() 
    {
        return vehicleLimt;
    }
    public void setVehicleInspect(String vehicleInspect) 
    {
        this.vehicleInspect = vehicleInspect;
    }

    public String getVehicleInspect() 
    {
        return vehicleInspect;
    }
    public void setPersonLiable(String personLiable) 
    {
        this.personLiable = personLiable;
    }

    public String getPersonLiable() 
    {
        return personLiable;
    }
    public void setOnState(String onState) 
    {
        this.onState = onState;
    }

    public String getOnState() 
    {
        return onState;
    }
    public void setVehicleUser(String vehicleUser)
    {
        this.vehicleUser = vehicleUser;
    }

    public String getVehicleUser()
    {
        return vehicleUser;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TLpgVehicleInfo lpgVehicleInfo = (TLpgVehicleInfo) obj;
        return Objects.equals(carNum,lpgVehicleInfo.getCarNum());
    }

    @Override
    public int hashCode() {
        return Objects.hash(carNum);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("vehicleId", getVehicleId())
            .append("stationName", getStationName())
            .append("carNumber", getCarNumber())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("vehicleCode", getVehicleCode())
            .append("carNum", getCarNum())
            .append("brandModel", getBrandModel())
            .append("vehicleType", getVehicleType())
            .append("vehicleLoad", getVehicleLoad())
            .append("vehicleSize", getVehicleSize())
            .append("vehicleLimt", getVehicleLimt())
            .append("vehicleInspect", getVehicleInspect())
            .append("personLiable", getPersonLiable())
            .append("onState", getOnState())
            .append("vehicleUser", getVehicleUser())
            .append("phone", getPhone())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
