package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 液化石油气-气瓶档案对象 t_lpg_gas_bottle_files
 * 
 * @author zehong
 * @date 2024-07-09
 */
public class TLpgGasBottleFiles extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long gasBottleFilesId;

    /**
     * 燃气企业名称
     */
    /** 燃气企业 */
    @Excel(name = "燃气企业")
    private String enterpriseName;

    /** 生产(制造单位) */
    @Excel(name = "生产(制造单位) ", width = 30 )
    private String makeInfo;

    /** 气瓶条码 */
    @Excel(name = "气瓶条码", width = 30 )
    private String qrcode;

    /** 登记证号 */
    @Excel(name = "登记证号", width = 30 )
    private String regCode;

    /** 产品编号 */
    @Excel(name = "产品编号", width = 30 )
    private String equNo;

    /** 设备类型 */
    @Excel(name = "设备类型", width = 30 )
    private String equType;

    /** 充装介质 */
    @Excel(name = "充装介质", width = 30 )
    private String medium;

    /** 生产日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生产日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date makeDate;

    /** 单位内编号 */
    @Excel(name = "单位内编号", width = 30 )
    private String selfId;

    /** 压力 */
    @Excel(name = "压力", width = 30 )
    private BigDecimal pressure;

    /** 体积 */
    private BigDecimal volume;

    /** 电子标签 */
    private String appId;


    /** 使用单位 */
    @Excel(name = "使用单位", width = 30 )
    private String buildUser;


    /** 录入日期 */
    private Date addTime;

    /** 录入人姓名 */
    private String optName;

    /** 更新日期 */
    private Date upTime;

    /** 状态1 新增、2 修改、-1、删除  （默认1） 3.注销 */
    //@Excel(name = "气瓶状态 ", readConverterExp = "1=新增,2=修改,-1=删除") 2024-09-13 wh 去掉，感觉监管不需要
    private String state;

    /** 修改人姓名 */
    private String upOptName;

    /** 上检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date pchkDate;

    /** 下检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nchkDate;

    /** 生产日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生产日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date productDate;

    /** 报废日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "报废日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date discardDate;

    /** 安全评定日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "安全评定日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date safeJudgeDate;

    /** 公称压力Mpa */
    @Excel(name = "公称压力/Mpa")
    private BigDecimal gpressure;

    /** 水试验压力Mpa */
    @Excel(name = "水试验压力/Mpa")
    private BigDecimal wpressure;

    /** 标准重量KG */
    @Excel(name = "标准重量/KG")
    private BigDecimal selfWeight;

    /** 壁厚mm */
    @Excel(name = "壁厚/mm")
    private BigDecimal thickness;

    /** 气瓶许可证号 */
    @Excel(name = "气瓶许可证号")
    private String permitNo;

    /** 阀类型名称 */
    @Excel(name = "阀类型名称")
    private String valveName;

    /** 钢瓶交付文件照片 */
    //@Excel(name = "钢瓶交付文件照片")
    private String payImage;

    /** 检验质量证明书照片 */
    //@Excel(name = "检验质量证明书照片")
    private String batchImage;

    /** 制造监督检验证书照片 */
    //@Excel(name = "制造监督检验证书照片")
    private String deviceImage;

    /** 检验报告照片 */
    //@Excel(name = "检验报告照片")
    private String checkImage;

    /** 产品编号照片 2024-09-13 wh 去掉 界面上不展示了*/
    //@Excel(name = "产品编号照片")
    private String equNoImage;

    /** 单位内编号照片 2024-09-13 wh 去掉 界面上不展示了*/
    //@Excel(name = "单位内编号照片")
    private String selfIdImage;

    /** 钢瓶信息照片 */
    //@Excel(name = "钢瓶信息照片")
    private String botImage;

    /** 钢瓶规格名称 */
    @Excel(name = "钢瓶规格名称")
    private String botSpecName;

    /** 钢瓶型号 */
    @Excel(name = "钢瓶型号")
    private String bottleType;

    /** 已检验次数 */
    @Excel(name = "已检验次数")
    private Long inspectedTimes;

    /** 是否专用(1:专用 2：托管) */
    //@Excel(name = "是否专用") 2024-09-13 wh 去掉，感觉监管不需要
    private String isSpecialized;

    /** 阀厂家 */
    @Excel(name = "阀厂家")
    private String valveManuFacturer;

    /** 检验标牌(有/无) */
    @Excel(name = "检验标牌")
    private String inspectionLabel;

    /** 第三方标签 */
    @Excel(name = "第三方标签")
    private String thirdPartyLabel;

    /** 孔洞码 */
    @Excel(name = "孔洞码")
    private String holeCode;

    /** 存储类型(气相/液相) */
    @Excel(name = "存储类型")
    private String bottleStorageType;

    private String rowVersion;

    /**
     * 燃气企业id
     */
    private String enterpriseId;

    public Long getGasBottleFilesId() {
        return gasBottleFilesId;
    }

    public void setGasBottleFilesId(Long gasBottleFilesId) {
        this.gasBottleFilesId = gasBottleFilesId;
    }

    public String getMakeInfo() {
        return makeInfo;
    }

    public void setMakeInfo(String makeInfo) {
        this.makeInfo = makeInfo;
    }
    public String getRegCode() {
        return regCode;
    }

    public void setRegCode(String regCode) {
        this.regCode = regCode;
    }

    public String getEquNo() {
        return equNo;
    }

    public void setEquNo(String equNo) {
        this.equNo = equNo;
    }

    public String getEquType() {
        return equType;
    }

    public void setEquType(String equType) {
        this.equType = equType;
    }

    public String getMedium() {
        return medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public String getSelfId() {
        return selfId;
    }

    public void setSelfId(String selfId) {
        this.selfId = selfId;
    }

    public BigDecimal getPressure() {
        return pressure;
    }

    public void setPressure(BigDecimal pressure) {
        this.pressure = pressure;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getBuildUser() {
        return buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getOptName() {
        return optName;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public Date getUpTime() {
        return upTime;
    }

    public void setUpTime(Date upTime) {
        this.upTime = upTime;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getUpOptName() {
        return upOptName;
    }

    public void setUpOptName(String upOptName) {
        this.upOptName = upOptName;
    }

    public Date getProductDate() {
        return productDate;
    }

    public void setProductDate(Date productDate) {
        this.productDate = productDate;
    }

    public Date getDiscardDate() {
        return discardDate;
    }

    public void setDiscardDate(Date discardDate) {
        this.discardDate = discardDate;
    }

    public Date getSafeJudgeDate() {
        return safeJudgeDate;
    }

    public void setSafeJudgeDate(Date safeJudgeDate) {
        this.safeJudgeDate = safeJudgeDate;
    }

    public BigDecimal getSelfWeight() {
        return selfWeight;
    }

    public void setSelfWeight(BigDecimal selfWeight) {
        this.selfWeight = selfWeight;
    }

    public BigDecimal getThickness() {
        return thickness;
    }

    public void setThickness(BigDecimal thickness) {
        this.thickness = thickness;
    }

    public String getPermitNo() {
        return permitNo;
    }

    public void setPermitNo(String permitNo) {
        this.permitNo = permitNo;
    }

    public String getValveName() {
        return valveName;
    }

    public void setValveName(String valveName) {
        this.valveName = valveName;
    }

    public String getPayImage() {
        return payImage;
    }

    public void setPayImage(String payImage) {
        this.payImage = payImage;
    }

    public String getBatchImage() {
        return batchImage;
    }

    public void setBatchImage(String batchImage) {
        this.batchImage = batchImage;
    }

    public String getDeviceImage() {
        return deviceImage;
    }

    public void setDeviceImage(String deviceImage) {
        this.deviceImage = deviceImage;
    }

    public String getCheckImage() {
        return checkImage;
    }

    public void setCheckImage(String checkImage) {
        this.checkImage = checkImage;
    }

    public String getEquNoImage() {
        return equNoImage;
    }

    public void setEquNoImage(String equNoImage) {
        this.equNoImage = equNoImage;
    }

    public String getSelfIdImage() {
        return selfIdImage;
    }

    public void setSelfIdImage(String selfIdImage) {
        this.selfIdImage = selfIdImage;
    }

    public String getBotImage() {
        return botImage;
    }

    public void setBotImage(String botImage) {
        this.botImage = botImage;
    }

    public String getBotSpecName() {
        return botSpecName;
    }

    public void setBotSpecName(String botSpecName) {
        this.botSpecName = botSpecName;
    }

    public String getBottleType() {
        return bottleType;
    }

    public void setBottleType(String bottleType) {
        this.bottleType = bottleType;
    }

    public Long getInspectedTimes() {
        return inspectedTimes;
    }

    public void setInspectedTimes(Long inspectedTimes) {
        this.inspectedTimes = inspectedTimes;
    }

    public String getIsSpecialized() {
        return isSpecialized;
    }

    public void setIsSpecialized(String isSpecialized) {
        this.isSpecialized = isSpecialized;
    }

    public String getValveManuFacturer() {
        return valveManuFacturer;
    }

    public void setValveManuFacturer(String valveManuFacturer) {
        this.valveManuFacturer = valveManuFacturer;
    }

    public String getInspectionLabel() {
        return inspectionLabel;
    }

    public void setInspectionLabel(String inspectionLabel) {
        this.inspectionLabel = inspectionLabel;
    }

    public String getThirdPartyLabel() {
        return thirdPartyLabel;
    }

    public void setThirdPartyLabel(String thirdPartyLabel) {
        this.thirdPartyLabel = thirdPartyLabel;
    }

    public String getHoleCode() {
        return holeCode;
    }

    public void setHoleCode(String holeCode) {
        this.holeCode = holeCode;
    }

    public String getBottleStorageType() {
        return bottleStorageType;
    }

    public void setBottleStorageType(String bottleStorageType) {
        this.bottleStorageType = bottleStorageType;
    }

    public String getRowVersion() {
        return rowVersion;
    }

    public void setRowVersion(String rowVersion) {
        this.rowVersion = rowVersion;
    }

    public String getQrcode() {
        return qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public Date getPchkDate() {
        return pchkDate;
    }

    public void setPchkDate(Date pchkDate) {
        this.pchkDate = pchkDate;
    }

    public Date getNchkDate() {
        return nchkDate;
    }

    public void setNchkDate(Date nchkDate) {
        this.nchkDate = nchkDate;
    }

    public BigDecimal getGpressure() {
        return gpressure;
    }

    public void setGpressure(BigDecimal gpressure) {
        this.gpressure = gpressure;
    }

    public BigDecimal getWpressure() {
        return wpressure;
    }

    public void setWpressure(BigDecimal wpressure) {
        this.wpressure = wpressure;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TLpgGasBottleFiles tLpgGasBottleFiles = (TLpgGasBottleFiles) obj;
        return Objects.equals(qrcode, tLpgGasBottleFiles.getQrcode());
    }

    @Override
    public int hashCode() {
        return Objects.hash(qrcode);
    }

    @Override
    public String toString() {
        return "TLpgGasBottleFiles{" +
                "gasBottleFilesId=" + gasBottleFilesId +
                ", makeInfo='" + makeInfo + '\'' +
                ", qRcode='" + qrcode + '\'' +
                ", regCode='" + regCode + '\'' +
                ", equNo='" + equNo + '\'' +
                ", equType='" + equType + '\'' +
                ", medium='" + medium + '\'' +
                ", makeDate=" + makeDate +
                ", selfId='" + selfId + '\'' +
                ", pressure=" + pressure +
                ", volume=" + volume +
                ", appId='" + appId + '\'' +
                ", buildUser='" + buildUser + '\'' +
                ", addTime=" + addTime +
                ", optName='" + optName + '\'' +
                ", upTime=" + upTime +
                ", state='" + state + '\'' +
                ", upOptName='" + upOptName + '\'' +
                ", pChkDate=" + pchkDate +
                ", nChkDate=" + nchkDate +
                ", productDate=" + productDate +
                ", discardDate=" + discardDate +
                ", safeJudgeDate=" + safeJudgeDate +
                ", gPressure=" + gpressure +
                ", wPressure=" + wpressure +
                ", selfWeight=" + selfWeight +
                ", thickness=" + thickness +
                ", permitNo='" + permitNo + '\'' +
                ", valveName='" + valveName + '\'' +
                ", payImage='" + payImage + '\'' +
                ", batchImage='" + batchImage + '\'' +
                ", deviceImage='" + deviceImage + '\'' +
                ", checkImage='" + checkImage + '\'' +
                ", equNoImage='" + equNoImage + '\'' +
                ", selfIdImage='" + selfIdImage + '\'' +
                ", botImage='" + botImage + '\'' +
                ", botSpecName='" + botSpecName + '\'' +
                ", bottleType='" + bottleType + '\'' +
                ", inspectedTimes=" + inspectedTimes +
                ", isSpecialized='" + isSpecialized + '\'' +
                ", valveManuFacturer='" + valveManuFacturer + '\'' +
                ", inspectionLabel='" + inspectionLabel + '\'' +
                ", thirdPartyLabel='" + thirdPartyLabel + '\'' +
                ", holeCode='" + holeCode + '\'' +
                ", bottleStorageType='" + bottleStorageType + '\'' +
                ", rowVersion='" + rowVersion + '\'' +
                '}';
    }
}
