package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-检查任务对象 t_ins_task_infor
 * 
 * @author zehong
 * @date 2024-05-16
 */
public class TInsTaskInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsTaskInforId;

    /** 任务唯一编码 */
    @Excel(name = "任务唯一编码")
    private String fUniqueCode;

    /** 任务归属：组织检查的燃气主管部门对应6位行政区划编码 */
    @Excel(name = "任务归属：组织检查的燃气主管部门对应6位行政区划编码")
    private String fTaskBelong;

    /** 任务类型 0-专项 1-日常 2-第三方评估抽查 3-随机抽

            查 */
    @Excel(name = "任务类型",dictType = "t_supervision_task_type")
    private String fTaskType;

    /** 是否下发 0-不下发 1 - 下发 */
    @Excel(name = "是否下发",dictType = "t_distribute_flag")
    private Long fDistributeFlag;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String fName;

    /** 任务说明 */
    @Excel(name = "任务说明")
    private String fDesc;

    /** 任务开始时间 yyyy-mm-dd */
    @Excel(name = "任务开始时间")
    private String fStartTime;

    /** 任务截至时间 yyyy-mm-dd */
    @Excel(name = "任务截至时间")
    private String fEndTime;

    /** 任务状态，NEW-未开始，ING-进行中，DON-已完结，OVD-超期未完成 */
    @Excel(name = "任务状态",dictType = "t_supervision_task_status")
    private String fStatus;

    /** 删除标记，0-可用，1-已删除 */
    @Excel(name = "删除标记",dictType = "t_delete_flag")
    private Long fDeleteFlag;

    /** 描述 */
    @Excel(name = "描述")
    private String fRemark;

    /** 创建时间精确到秒 */
    @Excel(name = "创建时间")
    private String fCreateTime;

    /** 创建人，当前操作人登录名称 */
    @Excel(name = "创建人")
    private String fCreateBy;

    /** 修改时间 精确到秒 */
    @Excel(name = "修改时间")
    private String fUpdateTime;

    /** 修改人，当前操作人登录名称 */
    @Excel(name = "修改人")
    private String fModifyBy;

    public void setfInsTaskInforId(Long fInsTaskInforId) 
    {
        this.fInsTaskInforId = fInsTaskInforId;
    }

    public Long getfInsTaskInforId() 
    {
        return fInsTaskInforId;
    }
    public void setfUniqueCode(String fUniqueCode) 
    {
        this.fUniqueCode = fUniqueCode;
    }

    public String getfUniqueCode() 
    {
        return fUniqueCode;
    }
    public void setfTaskBelong(String fTaskBelong) 
    {
        this.fTaskBelong = fTaskBelong;
    }

    public String getfTaskBelong() 
    {
        return fTaskBelong;
    }
    public void setfTaskType(String fTaskType) 
    {
        this.fTaskType = fTaskType;
    }

    public String getfTaskType() 
    {
        return fTaskType;
    }
    public void setfDistributeFlag(Long fDistributeFlag) 
    {
        this.fDistributeFlag = fDistributeFlag;
    }

    public Long getfDistributeFlag() 
    {
        return fDistributeFlag;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfDesc(String fDesc) 
    {
        this.fDesc = fDesc;
    }

    public String getfDesc() 
    {
        return fDesc;
    }
    public void setfStartTime(String fStartTime) 
    {
        this.fStartTime = fStartTime;
    }

    public String getfStartTime() 
    {
        return fStartTime;
    }
    public void setfEndTime(String fEndTime) 
    {
        this.fEndTime = fEndTime;
    }

    public String getfEndTime() 
    {
        return fEndTime;
    }
    public void setfStatus(String fStatus) 
    {
        this.fStatus = fStatus;
    }

    public String getfStatus() 
    {
        return fStatus;
    }
    public void setfDeleteFlag(Long fDeleteFlag) 
    {
        this.fDeleteFlag = fDeleteFlag;
    }

    public Long getfDeleteFlag() 
    {
        return fDeleteFlag;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfCreateTime(String fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public String getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfCreateBy(String fCreateBy) 
    {
        this.fCreateBy = fCreateBy;
    }

    public String getfCreateBy() 
    {
        return fCreateBy;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfModifyBy(String fModifyBy) 
    {
        this.fModifyBy = fModifyBy;
    }

    public String getfModifyBy() 
    {
        return fModifyBy;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsTaskInforId", getfInsTaskInforId())
            .append("fUniqueCode", getfUniqueCode())
            .append("fTaskBelong", getfTaskBelong())
            .append("fTaskType", getfTaskType())
            .append("fDistributeFlag", getfDistributeFlag())
            .append("fName", getfName())
            .append("fDesc", getfDesc())
            .append("fStartTime", getfStartTime())
            .append("fEndTime", getfEndTime())
            .append("fStatus", getfStatus())
            .append("fDeleteFlag", getfDeleteFlag())
            .append("fRemark", getfRemark())
            .append("fCreateTime", getfCreateTime())
            .append("fCreateBy", getfCreateBy())
            .append("fUpdateTime", getfUpdateTime())
            .append("fModifyBy", getfModifyBy())
            .toString();
    }
}
