package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-调查项对象 t_ins_sur_list_infor
 * 
 * @author zehong
 * @date 2024-05-18
 */
public class TInsSurListInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsSurListInforId;

    /** 关联的检查任务编码 */
    @Excel(name = "关联的检查任务编码")
    private String fCheckTaskCode;

    /** 检查对象分类，按分类代码表23 分类填写

            23-0100 ：气代煤

            23-0200-0201：传统电代煤

            23-0200-0202：石墨烯

            23-0200-0203：聚能

            23-0200-0204：空气源热泵

            23-0200-0205：地源热泵

            23-9900-0301：集中供热

            23-9900-0302：光伏+

            23-9900-0303：光热+

            23-9900-0304：醇基燃料

            23-9900-0305：生物质 */
    @Excel(name = "检查对象分类",dictType = "t_type_code")
    private String fTypeCode;

    /** 调查内容 */
    @Excel(name = "调查内容")
    private String fContents;

    /** 结果填写类型，1单选、2-多选、3 输入 */
    @Excel(name = "结果填写类型",dictType = "t_res_type")
    private Long fResType;

    /** 结果填写选项，单选和多选内容的可选项，以英文逗号间隔 */
    @Excel(name = "结果填写选项")
    private String fResOption;

    /** 顺序号，调查项在检查对象所有调查项中的顺序号 */
    @Excel(name = "顺序号")
    private Long ord;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "最后修改时间")
    private String fLastUpdateTime;

    public void setfInsSurListInforId(Long fInsSurListInforId) 
    {
        this.fInsSurListInforId = fInsSurListInforId;
    }

    public Long getfInsSurListInforId() 
    {
        return fInsSurListInforId;
    }
    public void setfCheckTaskCode(String fCheckTaskCode) 
    {
        this.fCheckTaskCode = fCheckTaskCode;
    }

    public String getfCheckTaskCode() 
    {
        return fCheckTaskCode;
    }
    public void setfTypeCode(String fTypeCode) 
    {
        this.fTypeCode = fTypeCode;
    }

    public String getfTypeCode() 
    {
        return fTypeCode;
    }
    public void setfContents(String fContents) 
    {
        this.fContents = fContents;
    }

    public String getfContents() 
    {
        return fContents;
    }
    public void setfResType(Long fResType) 
    {
        this.fResType = fResType;
    }

    public Long getfResType() 
    {
        return fResType;
    }
    public void setfResOption(String fResOption) 
    {
        this.fResOption = fResOption;
    }

    public String getfResOption() 
    {
        return fResOption;
    }
    public void setOrd(Long ord) 
    {
        this.ord = ord;
    }

    public Long getOrd() 
    {
        return ord;
    }
    public void setfLastUpdateTime(String fLastUpdateTime) 
    {
        this.fLastUpdateTime = fLastUpdateTime;
    }

    public String getfLastUpdateTime() 
    {
        return fLastUpdateTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsSurListInforId", getfInsSurListInforId())
            .append("fCheckTaskCode", getfCheckTaskCode())
            .append("fTypeCode", getfTypeCode())
            .append("fContents", getfContents())
            .append("fResType", getfResType())
            .append("fResOption", getfResOption())
            .append("ord", getOrd())
            .append("fLastUpdateTime", getfLastUpdateTime())
            .toString();
    }
}
