package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-调查结果对象 t_ins_spot_rec_infor
 * 
 * @author zehong
 * @date 2024-05-22
 */
public class TInsSpotRecInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsSpotRecInforId;

    /** 检查记录编码,实施检查的燃气主管部门对应 6 位行

            政区划编码+4 位年份+6 位 */
    @Excel(name = "检查记录编码")
    private String fCheckCode;

    /** 调研项目名称 */
    @Excel(name = "调研项目名称")
    private String fName;

    /** 调研内容 */
    @Excel(name = "调研内容")
    private String fContent;

    /** 调研方法

            1-现场检查、

            2-现场检测、

            3-现场检查并测试、

            4-现场检查和查阅记录、

            5-查阅检测报告、

            6- 查阅检定记录、

            7-查阅记录、

            8-其他 */
    @Excel(name = "调研方法",dictType = "t_survey_method")
    private String fMethod;

    /** 调研结果 */
    @Excel(name = "调研结果")
    private String fResult;

    /** 更新时间 yyyy-MM-dd hh:mm:ss */
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd hh:mm:ss")
    private Date fUpdateTime;

    /**
     * 上传状态0-未上传，1-已上传
     */
    @Excel(name = "上传状态",readConverterExp = "1=已上传,0=未上传")
    private String govUploadState;

    /**
     * 上传时间
     */
    @Excel(name = "上传时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date govUploadTime;

    private String taskCode;

    private String taskName;

    public void setfInsSpotRecInforId(Long fInsSpotRecInforId) 
    {
        this.fInsSpotRecInforId = fInsSpotRecInforId;
    }

    public Long getfInsSpotRecInforId() 
    {
        return fInsSpotRecInforId;
    }
    public void setfCheckCode(String fCheckCode) 
    {
        this.fCheckCode = fCheckCode;
    }

    public String getfCheckCode() 
    {
        return fCheckCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfContent(String fContent) 
    {
        this.fContent = fContent;
    }

    public String getfContent() 
    {
        return fContent;
    }
    public void setfMethod(String fMethod) 
    {
        this.fMethod = fMethod;
    }

    public String getfMethod() 
    {
        return fMethod;
    }
    public void setfResult(String fResult) 
    {
        this.fResult = fResult;
    }

    public String getfResult() 
    {
        return fResult;
    }
    public void setfUpdateTime(Date fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsSpotRecInforId", getfInsSpotRecInforId())
            .append("fCheckCode", getfCheckCode())
            .append("fName", getfName())
            .append("fContent", getfContent())
            .append("fMethod", getfMethod())
            .append("fResult", getfResult())
            .append("fUpdateTime", getfUpdateTime())
            .toString();
    }
}
