package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 监督检查-抽查隐患对象 t_ins_spot_hazard_ref
 * 
 * @author zehong
 * @date 2024-05-21
 */
public class TInsSpotHazardRef extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsSpotHazardRefId;

    /** 隐患唯一编码 */
    @Excel(name = "隐患唯一编码")
    private String fHazardUniqueCode;

    /** 隐患在市级平台系统中的自有编号 */
    @Excel(name = "隐患在市级平台系统中的自有编号")
    private String fHazardOutUniqueCode;

    /** 设计供气企业编码 */
    private String fInvolveEnterpriseCode;

    @Excel(name = "供气企业编码")
    private String enterpriseName;

    /** 检查对象分类，按分类代码表23 分类填写

            23-0100 ：气代煤

            23-0200-0201：传统电代煤

            23-0200-0202：石墨烯

            23-0200-0203：聚能

            23-0200-0204：空气源热泵

            23-0200-0205：地源热泵

            23-9900-0301：集中供热

            23-9900-0302：光伏+

            23-9900-0303：光热+

            23-9900-0304：醇基燃料

            23-9900-0305：生物质 */
    @Excel(name = "检查对象分类",dictType = "t_type_code")
    private String fObjType;

    /** 对象编码 */
    @Excel(name = "对象编码")
    private String fObjCode;

    /** 对象所在行政区，县级行政区ID */
    private Long fObjBelongRegionId;

    @Excel(name = "县级行政区")
    private String countyName;

    /** 监督检查时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "监督检查时间")
    private String fCheckTime;

    /** 隐患分类分级编码 */
    private Long fHazardTypeLevelId;

    @Excel(name = "隐患分类分级标准")
    private String levelName;

    /** 隐患分类分级标准中的内容不足以表述隐患，或隐患

            分类分级编码对应了“其他”类隐患的，应该用补充说

            明把隐患描述完整 */
    @Excel(name = "隐患描述")
    private String fHazardDesc;

    /** 隐患整改前照片 */
    @Excel(name = "隐患整改前照片")
    private String fBeforePicture;

    /** 是否执行：1 是 0 否 */
    @Excel(name = "是否执行",readConverterExp = "1=是,0=否")
    private String fIsEnforcement;

    /** 备注 */
    private String fRemark;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    private String fLastTime;

    /**
     * 隐患整改后照片
     */
    @Excel(name = "隐患整改后照片")
    private String afterPicture;

    /**
     * 处置描述
     */
    @Excel(name = "处置描述")
    private String disposalDetails;

    /**
     * 处置描述
     */
    @Excel(name = "处置时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date disposalTime;

    public Date getDisposalTime() {
        return disposalTime;
    }

    public void setDisposalTime(Date disposalTime) {
        this.disposalTime = disposalTime;
    }

    public String getAfterPicture() {
        return afterPicture;
    }

    public void setAfterPicture(String afterPicture) {
        this.afterPicture = afterPicture;
    }

    public String getDisposalDetails() {
        return disposalDetails;
    }

    public void setDisposalDetails(String disposalDetails) {
        this.disposalDetails = disposalDetails;
    }

    public void setfInsSpotHazardRefId(Long fInsSpotHazardRefId)
    {
        this.fInsSpotHazardRefId = fInsSpotHazardRefId;
    }

    public Long getfInsSpotHazardRefId() 
    {
        return fInsSpotHazardRefId;
    }
    public void setfHazardUniqueCode(String fHazardUniqueCode) 
    {
        this.fHazardUniqueCode = fHazardUniqueCode;
    }

    public String getfHazardUniqueCode() 
    {
        return fHazardUniqueCode;
    }
    public void setfHazardOutUniqueCode(String fHazardOutUniqueCode) 
    {
        this.fHazardOutUniqueCode = fHazardOutUniqueCode;
    }

    public String getfHazardOutUniqueCode() 
    {
        return fHazardOutUniqueCode;
    }
    public void setfInvolveEnterpriseCode(String fInvolveEnterpriseCode) 
    {
        this.fInvolveEnterpriseCode = fInvolveEnterpriseCode;
    }

    public String getfInvolveEnterpriseCode() 
    {
        return fInvolveEnterpriseCode;
    }
    public void setfObjType(String fObjType) 
    {
        this.fObjType = fObjType;
    }

    public String getfObjType() 
    {
        return fObjType;
    }
    public void setfObjCode(String fObjCode) 
    {
        this.fObjCode = fObjCode;
    }

    public String getfObjCode() 
    {
        return fObjCode;
    }
    public void setfObjBelongRegionId(Long fObjBelongRegionId)
    {
        this.fObjBelongRegionId = fObjBelongRegionId;
    }

    public Long getfObjBelongRegionId()
    {
        return fObjBelongRegionId;
    }
    public void setfCheckTime(String fCheckTime) 
    {
        this.fCheckTime = fCheckTime;
    }

    public String getfCheckTime() 
    {
        return fCheckTime;
    }
    public void setfHazardTypeLevelId(Long fHazardTypeLevelId)
    {
        this.fHazardTypeLevelId = fHazardTypeLevelId;
    }

    public Long getfHazardTypeLevelId()
    {
        return fHazardTypeLevelId;
    }
    public void setfHazardDesc(String fHazardDesc) 
    {
        this.fHazardDesc = fHazardDesc;
    }

    public String getfHazardDesc() 
    {
        return fHazardDesc;
    }
    public void setfBeforePicture(String fBeforePicture) 
    {
        this.fBeforePicture = fBeforePicture;
    }

    public String getfBeforePicture() 
    {
        return fBeforePicture;
    }
    public void setfIsEnforcement(String fIsEnforcement) 
    {
        this.fIsEnforcement = fIsEnforcement;
    }

    public String getfIsEnforcement() 
    {
        return fIsEnforcement;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfLastTime(String fLastTime) 
    {
        this.fLastTime = fLastTime;
    }

    public String getfLastTime() 
    {
        return fLastTime;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsSpotHazardRefId", getfInsSpotHazardRefId())
            .append("fHazardUniqueCode", getfHazardUniqueCode())
            .append("fHazardOutUniqueCode", getfHazardOutUniqueCode())
            .append("fInvolveEnterpriseCode", getfInvolveEnterpriseCode())
            .append("fObjType", getfObjType())
            .append("fObjCode", getfObjCode())
            .append("fObjBelongRegionId", getfObjBelongRegionId())
            .append("fCheckTime", getfCheckTime())
            .append("fHazardTypeLevelId", getfHazardTypeLevelId())
            .append("fHazardDesc", getfHazardDesc())
            .append("fBeforePicture", getfBeforePicture())
            .append("fIsEnforcement", getfIsEnforcement())
            .append("fRemark", getfRemark())
            .append("fLastTime", getfLastTime())
            .toString();
    }
}
