package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * 企业信息对象 t_enterprise_info
 *
 * @author zehong
 * @date 2022-01-24
 */
public class TEnterpriseInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 企业id */
    private String enterpriseId;

    /**创建企业id*/
    private String createEnterpriseId;



    /** 企业名称 */
    @Excel(name = "企业名称")
    private String enterpriseName;


    @Excel(name = "企业分类",dictType = "enterprise_type")
    private Integer enterpriseType;

    /** 注册地址 */
    @Excel(name = "注册地址")
    private String registerAddress;

    /** 法定代表人 */
    @Excel(name = "法定代表人")
    private String legalRepresentative;

    /** 经营区域 */
    @Excel(name = "经营区域")
    private String businessArea;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 图表类型 */
    private String iconType;

    /** 许可证编号 */
    @Excel(name = "许可证编号")
    private String licenseKey;

    public String getHaslicenseKey() {
        return haslicenseKey;
    }

    public void setHaslicenseKey(String haslicenseKey) {
        this.haslicenseKey = haslicenseKey;
    }

    //是否有许可证
    private String haslicenseKey;

    /** 许可证有效期 */
    @Excel(name = "许可证有效期")
    private String licenseValidityTime;

    /** 年度监督检查情况 */
    @Excel(name = "年度监督检查情况")
    private String annualSupervisionInspection;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 营业执照图片地址*/
    private String doDusiness;

    /**本地存储图片路径*/
    private String burl;

    public Integer getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(Integer enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getCreateEnterpriseId() {
        return createEnterpriseId;
    }

    public void setCreateEnterpriseId(String createEnterpriseId) {
        this.createEnterpriseId = createEnterpriseId;
    }

    public String getBurl() {
        return burl;
    }

    public void setBurl(String burl) {
        this.burl = burl;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getDoDusiness() {
        return doDusiness;
    }

    public void setDoDusiness(String doDusiness) {
        this.doDusiness = doDusiness;
    }

    public void setEnterpriseId(String enterpriseId)
    {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseId()
    {
        return enterpriseId;
    }
    public void setEnterpriseName(String enterpriseName)
    {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseName()
    {
        return enterpriseName;
    }
    public void setRegisterAddress(String registerAddress)
    {
        this.registerAddress = registerAddress;
    }

    public String getRegisterAddress()
    {
        return registerAddress;
    }
    public void setLegalRepresentative(String legalRepresentative)
    {
        this.legalRepresentative = legalRepresentative;
    }

    public String getLegalRepresentative()
    {
        return legalRepresentative;
    }
    public void setBusinessArea(String businessArea)
    {
        this.businessArea = businessArea;
    }

    public String getBusinessArea()
    {
        return businessArea;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setLicenseKey(String licenseKey)
    {
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey()
    {
        return licenseKey;
    }
    public void setLicenseValidityTime(String licenseValidityTime)
    {
        this.licenseValidityTime = licenseValidityTime;
    }

    public String getLicenseValidityTime()
    {
        return licenseValidityTime;
    }
    public void setAnnualSupervisionInspection(String annualSupervisionInspection)
    {
        this.annualSupervisionInspection = annualSupervisionInspection;
    }

    public String getIconType() {
        return iconType;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public String getAnnualSupervisionInspection()
    {
        return annualSupervisionInspection;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TEnterpriseInfo{" +
                "enterpriseId=" + enterpriseId +
                ", createEnterpriseId=" + createEnterpriseId +
                ", enterpriseName='" + enterpriseName + '\'' +
                ", registerAddress='" + registerAddress + '\'' +
                ", legalRepresentative='" + legalRepresentative + '\'' +
                ", businessArea='" + businessArea + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", iconType='" + iconType + '\'' +
                ", licenseKey='" + licenseKey + '\'' +
                ", licenseValidityTime='" + licenseValidityTime + '\'' +
                ", annualSupervisionInspection='" + annualSupervisionInspection + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", doDusiness='" + doDusiness + '\'' +
                ", burl='" + burl + '\'' +
                '}';
    }
}
