package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.utils.DateUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 第三方施工-涉气第三方施工项目档案对象 t_con_gas_pro_infor
 * 
 * @author zehong
 * @date 2024-06-26
 */
public class TConGasProInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fConGasProInforId;

    /** 燃气企业编码 */
    private String fCompanyInfoId;

    @Excel(name = "燃气企业")
    private String companyInfoName;

    /** 所属县级行政区ID */
    private Long fDistrictId;

    @Excel(name = "所属县级行政区")
    private String districtName;

    /** 项目编码，6位县级行政区划编码+4位年+4位顺序码 */
    @Excel(name = "项目编码")
    private String fProjectCode;

    /** 外部工程编码，工程项目在市级平台或燃气企业系统中的自有编号 */
    @Excel(name = "外部工程编码")
    private String fProjectNo;

    /** 施工工程项目名称 */
    @Excel(name = "施工工程项目名称")
    private String fProjectName;

    /** 开工时间 yyyy-MM-dd */
    @Excel(name = "开工时间")
    private String fConstructionStart;

    /** 计划竣工时间 yyyy-MM-dd */
    @Excel(name = "计划竣工时间")
    private String fConstructionEnd;

    /** 项目位置描述 */
    @Excel(name = "项目位置描述")
    private String fAddress;


    /** 经度 */
    @Excel(name = "经度")
    private String fConstructionLongitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private String fConstructionLatitude;

    /** 涉气施工点位位置属性 1城镇，2 农村 */
    @Excel(name = "涉气施工点位位置属性",readConverterExp = "1=城镇,2=农村")
    private String fConstructionPointType;

    /** 涉及村，村级行政区ID */
    private Long fVillageId;

    /** 管道压力等级分类，按分类代码表14分类填写

            140100：超高压       4.0 &lt; p

            140200：高压        1.6&lt; p &lt;= 4.0

            140300：次高压     0.4&lt;p&lt;1.6

            140400：中压         0.01&lt;p&lt;=0.4

            140500：低压         p &lt; 0.01 */
    @Excel(name = "管道压力等级分类",dictType = "t_pipe_press")
    private String fPipePress;

    /** 施工是否主动报备 1 是  0 否 */
    @Excel(name = "施工是否主动报备",readConverterExp = "1=是,0=否")
    private String fReportFlag;

    /** 施工状态，1 未开工，2 正在施工，3 已完工 */
    @Excel(name = "施工状态",readConverterExp = "1=未开工,2=正在施工,3=已完工")
    private String fConstructionStatus;

    /** 建设单位名称 */
    @Excel(name = "建设单位名称")
    private String fBuildDepartment;

    /** 建设单位项目负责人姓名 */
    @Excel(name = "建设单位项目负责人姓名")
    private String fProjectLeader;

    /** 建设单位项目负责人电话 */
    @Excel(name = "建设单位项目负责人电话")
    private String fProjectLeaderPhone;

    /** 所属行业，发展改革/水利/农业农村/交通/通信/住建(城管) */
    @Excel(name = "所属行业")
    private String fIndustry;

    /** 行业安全监管部门名称 */
    @Excel(name = "行业安全监管部门名称")
    private String fDepartmentName;

    /** 施工单位名称 */
    @Excel(name = "施工单位名称")
    private String fConstructDepartment;

    /** 施工单位项目负责人姓名 */
    @Excel(name = "施工单位项目负责人姓名")
    private String fBuildProjectLeaderName;

    /** 施工单位项目负责人电话 */
    @Excel(name = "施工单位项目负责人电话")
    private String fBuildProjectLeaderPhone;

    /** 施工单位技术负责人姓名 */
    @Excel(name = "施工单位技术负责人姓名")
    private String fTechnicalLeaderName;

    /** 施工单位技术负责人电话 */
    @Excel(name = "施工单位技术负责人电话")
    private String fTechnicalLeaderPhone;

    /** 监理单位名称 */
    @Excel(name = "监理单位名称")
    private String fSupervisionUnitName;

    /** 监理单位总监理工程师姓名 */
    @Excel(name = "监理单位总监理工程师姓名")
    private String fChiefEngineerName;

    /** 监理单位总监理工程师电话 */
    @Excel(name = "监理单位总监理工程师电话")
    private String fChiefEngineerPhone;


    /** 施工点位巡线员编码 */
    @Excel(name = "施工点位巡线员编码")
    private String fPatrolSafetyOfficerNo;

    /** 施工点位巡线员姓名 */
    @Excel(name = "施工点位巡线员姓名")
    private String fPartrolSafetyOfficerName;

    /** 施工点位巡线员电话 */
    @Excel(name = "施工点位巡线员电话")
    private String fPatrolSafetyOfficerPhone;

    /** 驻村安全员编码 */
    @Excel(name = "驻村安全员编码")
    private String fResidentSafetyOfficerNo;

    /** 驻村安全员姓名 */
    @Excel(name = "驻村安全员姓名")
    private String fResidentSafetyOfficerName;

    /** 驻村安全员电话 */
    @Excel(name = "驻村安全员电话")
    private String fResidentSafetyOfficerPhone;

    /** 燃气企业旁站人员编码 */
    @Excel(name = "燃气企业旁站人员编码")
    private String fGasCompanyStationNo;

    /** 燃气企业旁站人员姓名 */
    @Excel(name = "燃气企业旁站人员姓名")
    private String fGasCompanyStationName;

    /** 燃气企业旁站人员电话 */
    @Excel(name = "燃气企业旁站人员电话")
    private String fGasCompanyStationPhone;

    /** 备注 */
    private String fRemark;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    private String fUpdateTime;

    /**
     * 企业端上传状态 0-未上传，1-已上传*/
    @Excel(name = "上报状态",readConverterExp = "1=已上报,0=未上报")
    private String entUploadState;

    /**
     * 企业端上传时间 */
    @Excel(name = "上报时间",dateFormat = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date entUploadTime;


    /**
     * 企业端上传状态 0-未上报，1-已上报*/
    @Excel(name = "上报省厅状态",readConverterExp = "1=已上报,0=未上报")
    private String govUploadState;


    /**
     * 政府端上传时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上传省厅时间",dateFormat = "yyyy-MM-dd HH:mm")
    private Date govUploadTime;

    public void updateFields() {
        this.entUploadState = govUploadState;
        if (govUploadTime != null) {
            this.entUploadTime =  govUploadTime;
        } else {
            this.entUploadTime = null;
        }
    }
    public void setfConGasProInforId(Long fConGasProInforId) 
    {
        this.fConGasProInforId = fConGasProInforId;
    }

    public Long getfConGasProInforId() 
    {
        return fConGasProInforId;
    }
    public void setfProjectCode(String fProjectCode) 
    {
        this.fProjectCode = fProjectCode;
    }

    public String getfProjectCode() 
    {
        return fProjectCode;
    }
    public void setfProjectNo(String fProjectNo)
    {
        this.fProjectNo = fProjectNo;
    }

    public String getfProjectNo()
    {
        return fProjectNo;
    }
    public void setfProjectName(String fProjectName) 
    {
        this.fProjectName = fProjectName;
    }

    public String getfProjectName() 
    {
        return fProjectName;
    }
    public void setfConstructionStart(String fConstructionStart) 
    {
        this.fConstructionStart = fConstructionStart;
    }

    public String getfConstructionStart() 
    {
        return fConstructionStart;
    }
    public void setfConstructionEnd(String fConstructionEnd) 
    {
        this.fConstructionEnd = fConstructionEnd;
    }

    public String getfConstructionEnd() 
    {
        return fConstructionEnd;
    }
    public void setfAddress(String fAddress) 
    {
        this.fAddress = fAddress;
    }

    public String getfAddress() 
    {
        return fAddress;
    }
    public void setfDistrictId(Long fDistrictId) 
    {
        this.fDistrictId = fDistrictId;
    }

    public Long getfDistrictId() 
    {
        return fDistrictId;
    }
    public void setfConstructionLongitude(String fConstructionLongitude) 
    {
        this.fConstructionLongitude = fConstructionLongitude;
    }

    public String getfConstructionLongitude() 
    {
        return fConstructionLongitude;
    }
    public void setfConstructionLatitude(String fConstructionLatitude) 
    {
        this.fConstructionLatitude = fConstructionLatitude;
    }

    public String getfConstructionLatitude() 
    {
        return fConstructionLatitude;
    }
    public void setfConstructionPointType(String fConstructionPointType)
    {
        this.fConstructionPointType = fConstructionPointType;
    }

    public String getfConstructionPointType()
    {
        return fConstructionPointType;
    }
    public void setfVillageId(Long fVillageId) 
    {
        this.fVillageId = fVillageId;
    }

    public Long getfVillageId() 
    {
        return fVillageId;
    }
    public void setfPipePress(String fPipePress) 
    {
        this.fPipePress = fPipePress;
    }

    public String getfPipePress() 
    {
        return fPipePress;
    }
    public void setfReportFlag(String fReportFlag)
    {
        this.fReportFlag = fReportFlag;
    }

    public String getfReportFlag()
    {
        return fReportFlag;
    }
    public void setfConstructionStatus(String fConstructionStatus)
    {
        this.fConstructionStatus = fConstructionStatus;
    }

    public String getfConstructionStatus()
    {
        return fConstructionStatus;
    }
    public void setfBuildDepartment(String fBuildDepartment) 
    {
        this.fBuildDepartment = fBuildDepartment;
    }

    public String getfBuildDepartment() 
    {
        return fBuildDepartment;
    }
    public void setfProjectLeader(String fProjectLeader) 
    {
        this.fProjectLeader = fProjectLeader;
    }

    public String getfProjectLeader() 
    {
        return fProjectLeader;
    }
    public void setfProjectLeaderPhone(String fProjectLeaderPhone) 
    {
        this.fProjectLeaderPhone = fProjectLeaderPhone;
    }

    public String getfProjectLeaderPhone() 
    {
        return fProjectLeaderPhone;
    }
    public void setfIndustry(String fIndustry) 
    {
        this.fIndustry = fIndustry;
    }

    public String getfIndustry() 
    {
        return fIndustry;
    }
    public void setfDepartmentName(String fDepartmentName) 
    {
        this.fDepartmentName = fDepartmentName;
    }

    public String getfDepartmentName() 
    {
        return fDepartmentName;
    }
    public void setfConstructDepartment(String fConstructDepartment) 
    {
        this.fConstructDepartment = fConstructDepartment;
    }

    public String getfConstructDepartment() 
    {
        return fConstructDepartment;
    }
    public void setfBuildProjectLeaderName(String fBuildProjectLeaderName) 
    {
        this.fBuildProjectLeaderName = fBuildProjectLeaderName;
    }

    public String getfBuildProjectLeaderName() 
    {
        return fBuildProjectLeaderName;
    }
    public void setfBuildProjectLeaderPhone(String fBuildProjectLeaderPhone) 
    {
        this.fBuildProjectLeaderPhone = fBuildProjectLeaderPhone;
    }

    public String getfBuildProjectLeaderPhone() 
    {
        return fBuildProjectLeaderPhone;
    }
    public void setfTechnicalLeaderName(String fTechnicalLeaderName) 
    {
        this.fTechnicalLeaderName = fTechnicalLeaderName;
    }

    public String getfTechnicalLeaderName() 
    {
        return fTechnicalLeaderName;
    }
    public void setfTechnicalLeaderPhone(String fTechnicalLeaderPhone) 
    {
        this.fTechnicalLeaderPhone = fTechnicalLeaderPhone;
    }

    public String getfTechnicalLeaderPhone() 
    {
        return fTechnicalLeaderPhone;
    }
    public void setfSupervisionUnitName(String fSupervisionUnitName) 
    {
        this.fSupervisionUnitName = fSupervisionUnitName;
    }

    public String getfSupervisionUnitName() 
    {
        return fSupervisionUnitName;
    }
    public void setfChiefEngineerName(String fChiefEngineerName) 
    {
        this.fChiefEngineerName = fChiefEngineerName;
    }

    public String getfChiefEngineerName() 
    {
        return fChiefEngineerName;
    }
    public void setfChiefEngineerPhone(String fChiefEngineerPhone) 
    {
        this.fChiefEngineerPhone = fChiefEngineerPhone;
    }

    public String getfChiefEngineerPhone() 
    {
        return fChiefEngineerPhone;
    }
    public void setfCompanyInfoId(String fCompanyInfoId) 
    {
        this.fCompanyInfoId = fCompanyInfoId;
    }

    public String getfCompanyInfoId() 
    {
        return fCompanyInfoId;
    }
    public void setfPatrolSafetyOfficerNo(String fPatrolSafetyOfficerNo) 
    {
        this.fPatrolSafetyOfficerNo = fPatrolSafetyOfficerNo;
    }

    public String getfPatrolSafetyOfficerNo() 
    {
        return fPatrolSafetyOfficerNo;
    }
    public void setfPartrolSafetyOfficerName(String fPartrolSafetyOfficerName) 
    {
        this.fPartrolSafetyOfficerName = fPartrolSafetyOfficerName;
    }

    public String getfPartrolSafetyOfficerName() 
    {
        return fPartrolSafetyOfficerName;
    }
    public void setfPatrolSafetyOfficerPhone(String fPatrolSafetyOfficerPhone) 
    {
        this.fPatrolSafetyOfficerPhone = fPatrolSafetyOfficerPhone;
    }

    public String getfPatrolSafetyOfficerPhone() 
    {
        return fPatrolSafetyOfficerPhone;
    }
    public void setfResidentSafetyOfficerNo(String fResidentSafetyOfficerNo) 
    {
        this.fResidentSafetyOfficerNo = fResidentSafetyOfficerNo;
    }

    public String getfResidentSafetyOfficerNo() 
    {
        return fResidentSafetyOfficerNo;
    }
    public void setfResidentSafetyOfficerName(String fResidentSafetyOfficerName) 
    {
        this.fResidentSafetyOfficerName = fResidentSafetyOfficerName;
    }

    public String getfResidentSafetyOfficerName() 
    {
        return fResidentSafetyOfficerName;
    }
    public void setfResidentSafetyOfficerPhone(String fResidentSafetyOfficerPhone) 
    {
        this.fResidentSafetyOfficerPhone = fResidentSafetyOfficerPhone;
    }

    public String getfResidentSafetyOfficerPhone() 
    {
        return fResidentSafetyOfficerPhone;
    }
    public void setfGasCompanyStationNo(String fGasCompanyStationNo) 
    {
        this.fGasCompanyStationNo = fGasCompanyStationNo;
    }

    public String getfGasCompanyStationNo() 
    {
        return fGasCompanyStationNo;
    }
    public void setfGasCompanyStationName(String fGasCompanyStationName) 
    {
        this.fGasCompanyStationName = fGasCompanyStationName;
    }

    public String getfGasCompanyStationName() 
    {
        return fGasCompanyStationName;
    }
    public void setfGasCompanyStationPhone(String fGasCompanyStationPhone) 
    {
        this.fGasCompanyStationPhone = fGasCompanyStationPhone;
    }

    public String getfGasCompanyStationPhone() 
    {
        return fGasCompanyStationPhone;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }

    public Date getEntUploadTime() {
        return entUploadTime;
    }

    public void setEntUploadTime(Date entUploadTime) {
        this.entUploadTime = entUploadTime;
    }

    public String getEntUploadState() {
        return entUploadState;
    }

    public void setEntUploadState(String entUploadState) {
        this.entUploadState = entUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public String getCompanyInfoName() {
        return companyInfoName;
    }

    public void setCompanyInfoName(String companyInfoName) {
        this.companyInfoName = companyInfoName;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fConGasProInforId", getfConGasProInforId())
            .append("fProjectCode", getfProjectCode())
            .append("fProjectNo", getfProjectNo())
            .append("fProjectName", getfProjectName())
            .append("fConstructionStart", getfConstructionStart())
            .append("fConstructionEnd", getfConstructionEnd())
            .append("fAddress", getfAddress())
            .append("fDistrictId", getfDistrictId())
            .append("fConstructionLongitude", getfConstructionLongitude())
            .append("fConstructionLatitude", getfConstructionLatitude())
            .append("fConstructionPointType", getfConstructionPointType())
            .append("fVillageId", getfVillageId())
            .append("fPipePress", getfPipePress())
            .append("fReportFlag", getfReportFlag())
            .append("fConstructionStatus", getfConstructionStatus())
            .append("fBuildDepartment", getfBuildDepartment())
            .append("fProjectLeader", getfProjectLeader())
            .append("fProjectLeaderPhone", getfProjectLeaderPhone())
            .append("fIndustry", getfIndustry())
            .append("fDepartmentName", getfDepartmentName())
            .append("fConstructDepartment", getfConstructDepartment())
            .append("fBuildProjectLeaderName", getfBuildProjectLeaderName())
            .append("fBuildProjectLeaderPhone", getfBuildProjectLeaderPhone())
            .append("fTechnicalLeaderName", getfTechnicalLeaderName())
            .append("fTechnicalLeaderPhone", getfTechnicalLeaderPhone())
            .append("fSupervisionUnitName", getfSupervisionUnitName())
            .append("fChiefEngineerName", getfChiefEngineerName())
            .append("fChiefEngineerPhone", getfChiefEngineerPhone())
            .append("fCompanyInfoId", getfCompanyInfoId())
            .append("fPatrolSafetyOfficerNo", getfPatrolSafetyOfficerNo())
            .append("fPartrolSafetyOfficerName", getfPartrolSafetyOfficerName())
            .append("fPatrolSafetyOfficerPhone", getfPatrolSafetyOfficerPhone())
            .append("fResidentSafetyOfficerNo", getfResidentSafetyOfficerNo())
            .append("fResidentSafetyOfficerName", getfResidentSafetyOfficerName())
            .append("fResidentSafetyOfficerPhone", getfResidentSafetyOfficerPhone())
            .append("fGasCompanyStationNo", getfGasCompanyStationNo())
            .append("fGasCompanyStationName", getfGasCompanyStationName())
            .append("fGasCompanyStationPhone", getfGasCompanyStationPhone())
            .append("fRemark", getfRemark())
            .append("fUpdateTime", getfUpdateTime())
            .toString();
    }
}
