package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 第三方施工-涉气第三方施工意外事件对象 t_con_gas_pro_inc
 * 
 * @author zehong
 * @date 2024-06-27
 */
public class TConGasProInc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fConGasProIncId;

    /** 项目编码 */
    private String fIntersectConstructionId;


    /** 燃气企业 */
    @Excel(name = "燃气企业")
    private String fCompanyInfoId;

    @Excel(name = "项目编码")
    private String projectCode;

    /** 意外事件标题 */
    @Excel(name = "意外事件标题")
    private String fTitle;

    /** 意外事件描述，施工过程中发生了燃气管道破坏的情况，但及时妥善处置，未发生事故的详细情况 */
    @Excel(name = "意外事件描述")
    private String fDescription;

    /** 意外事件发生事件 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "意外事件发生事件时间")
    private String fOccurrenctTime;

    /** 附件 */
    @Excel(name = "附件")
    private String fAttachment;

    /** 备注 */
    @Excel(name = "备注")
    private String fRemark;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    private String fUpdateTime;

    /**
     * 企业端上传状态 0-未上传，1-已上传*/
    @Excel(name = "上报状态",readConverterExp = "1=已上报,0=未上报")
    private String entUploadState;

    /**
     * 企业端上传时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报时间",dateFormat = "yyyy-MM-dd HH:mm")
    private Date entUploadTime;

    /**
     * 企业端上传状态 0-未上报，1-已上报*/
    @Excel(name = "上报省厅状态",readConverterExp = "1=已上报,0=未上报")
    private String govUploadState;

    /**
     * 政府端上传时间 */
    @Excel(name = "上报省厅时间",dateFormat = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date govUploadTime;


    public void updateFields() {
        this.entUploadState = govUploadState;
        if (govUploadTime != null) {
            this.entUploadTime =  govUploadTime;
        } else {
            this.entUploadTime = null;
        }
    }
    public Date getEntUploadTime() {
        return entUploadTime;
    }

    public void setEntUploadTime(Date entUploadTime) {
        this.entUploadTime = entUploadTime;
    }

    public String getEntUploadState() {
        return entUploadState;
    }

    public void setEntUploadState(String entUploadState) {
        this.entUploadState = entUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public String getfCompanyInfoId() {
        return fCompanyInfoId;
    }

    public void setfCompanyInfoId(String fCompanyInfoId) {
        this.fCompanyInfoId = fCompanyInfoId;
    }

    public void setfConGasProIncId(Long fConGasProIncId)
    {
        this.fConGasProIncId = fConGasProIncId;
    }

    public Long getfConGasProIncId() 
    {
        return fConGasProIncId;
    }
    public void setfIntersectConstructionId(String fIntersectConstructionId) 
    {
        this.fIntersectConstructionId = fIntersectConstructionId;
    }

    public String getfIntersectConstructionId() 
    {
        return fIntersectConstructionId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public void setfTitle(String fTitle)
    {
        this.fTitle = fTitle;
    }

    public String getfTitle() 
    {
        return fTitle;
    }
    public void setfDescription(String fDescription) 
    {
        this.fDescription = fDescription;
    }

    public String getfDescription() 
    {
        return fDescription;
    }
    public void setfOccurrenctTime(String fOccurrenctTime) 
    {
        this.fOccurrenctTime = fOccurrenctTime;
    }

    public String getfOccurrenctTime() 
    {
        return fOccurrenctTime;
    }
    public void setfAttachment(String fAttachment) 
    {
        this.fAttachment = fAttachment;
    }

    public String getfAttachment() 
    {
        return fAttachment;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fConGasProIncId", getfConGasProIncId())
            .append("fIntersectConstructionId", getfIntersectConstructionId())
            .append("fTitle", getfTitle())
            .append("fDescription", getfDescription())
            .append("fOccurrenctTime", getfOccurrenctTime())
            .append("fAttachment", getfAttachment())
            .append("fRemark", getfRemark())
            .append("fUpdateTime", getfUpdateTime())
            .toString();
    }
}
