package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 投诉处置对象 t_complain_deal
 * 
 * @author zehong
 * @date 2022-02-15
 */
public class TComplainDeal extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 投诉处置id */
    private Long complainDealId;

    /** 投诉人姓名 */
    @Excel(name = "投诉人姓名")
    private String complainName;

    /** 投诉人电话 */
    @Excel(name = "投诉人电话")
    private String complainPhone;

    /** 投诉事项 */
    @Excel(name = "投诉事项")
    private String complainMatter;

    /** 转办记录 */
    @Excel(name = "转办记录")
    private String transferRecord;

    @Excel(name = "反馈时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date dealTime;
    /** 办理情况 */
    @Excel(name = "办理反馈情况")
    private String dealCondition;

    /** 指派单位名称 */
    @Excel(name = "指派单位名称")
    private String complainAssignEnterproseName;

    /** 指派单位id */
    @Excel(name = "指派单位id")
    private String complainAssignEnterproseId;

    /** 指派人 */
    @Excel(name = "指派人id")
    private Long complainAssignManId;

    /** 指派人id */
    @Excel(name = "指派人")
    private String complainAssignMan;

    /** 任务状态：1.派发中 2.反馈 3.归档 */
    @Excel(name = "任务状态：1.派发中 2.反馈 3.归档 4.企业退回")
    private String complainStatus;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /*投诉类别 */
    private String complainType;

    //    超时督办 0-创建，1-企业反馈，2-确认反馈，不确认时监管部门直接改成 0
    private String overtimeSupervision;

    //   所属区域
    private String township;
    /*
     * 省厅数据源或平台自建数据源(0-自建，1-省厅)，默认0-自建
     */
    private String provincialDataFlag;

    public String getProvincialDataFlag() {
        return provincialDataFlag;
    }

    public void setProvincialDataFlag(String provincialDataFlag) {
        this.provincialDataFlag = provincialDataFlag;
    }

    public void setComplainDealId(Long complainDealId)
    {
        this.complainDealId = complainDealId;
    }

    public Long getComplainDealId() 
    {
        return complainDealId;
    }
    public void setComplainName(String complainName) 
    {
        this.complainName = complainName;
    }

    public String getComplainName() 
    {
        return complainName;
    }
    public void setComplainPhone(String complainPhone) 
    {
        this.complainPhone = complainPhone;
    }

    public String getComplainPhone() 
    {
        return complainPhone;
    }
    public void setComplainMatter(String complainMatter) 
    {
        this.complainMatter = complainMatter;
    }

    public String getComplainMatter() 
    {
        return complainMatter;
    }
    public void setTransferRecord(String transferRecord) 
    {
        this.transferRecord = transferRecord;
    }

    public String getTransferRecord() 
    {
        return transferRecord;
    }
    public void setDealCondition(String dealCondition) 
    {
        this.dealCondition = dealCondition;
    }

    public String getDealCondition() 
    {
        return dealCondition;
    }
    public void setComplainAssignEnterproseName(String complainAssignEnterproseName) 
    {
        this.complainAssignEnterproseName = complainAssignEnterproseName;
    }

    public String getComplainAssignEnterproseName() 
    {
        return complainAssignEnterproseName;
    }
    public void setComplainAssignEnterproseId(String complainAssignEnterproseId)
    {
        this.complainAssignEnterproseId = complainAssignEnterproseId;
    }

    public String getComplainAssignEnterproseId()
    {
        return complainAssignEnterproseId;
    }
    public void setComplainAssignManId(Long complainAssignManId)
    {
        this.complainAssignManId = complainAssignManId;
    }

    public Long getComplainAssignManId()
    {
        return complainAssignManId;
    }
    public void setComplainAssignMan(String complainAssignMan)
    {
        this.complainAssignMan = complainAssignMan;
    }

    public String getComplainAssignMan()
    {
        return complainAssignMan;
    }
    public void setComplainStatus(String complainStatus) 
    {
        this.complainStatus = complainStatus;
    }

    public String getComplainStatus() 
    {
        return complainStatus;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public String getComplainType() {
        return complainType;
    }

    public void setComplainType(String complainType) {
        this.complainType = complainType;
    }

    public String getOvertimeSupervision() {
        return overtimeSupervision;
    }

    public void setOvertimeSupervision(String overtimeSupervision) {
        this.overtimeSupervision = overtimeSupervision;
    }

    public String getTownship() {
        return township;
    }

    public void setTownship(String township) {
        this.township = township;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("complainDealId", getComplainDealId())
            .append("complainName", getComplainName())
            .append("complainPhone", getComplainPhone())
            .append("complainMatter", getComplainMatter())
            .append("transferRecord", getTransferRecord())
            .append("dealCondition", getDealCondition())
            .append("complainAssignEnterproseName", getComplainAssignEnterproseName())
            .append("complainAssignEnterproseId", getComplainAssignEnterproseId())
            .append("complainAssignManId", getComplainAssignManId())
            .append("complainAssignMan", getComplainAssignMan())
            .append("complainStatus", getComplainStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
