package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 行业专家库-专家行为申报对象 f_pro_beh_infor
 * 
 * @author zehong
 * @date 2024-05-09
 */
public class FProBehInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fProBehInforId;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String fIdNo;

    /** 姓名 */
    @Excel(name = "姓名")
    private String fName;

    /** 专家表现评价 */
    @Excel(name = "专家表现评价")
    private String fExpertEval;

    /** 选用事件 */
    @Excel(name = "选用事件")
    private String fSelectionEvent;

    /** 选用开始时间 */
    @Excel(name = "选用开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private String fSelectionStartTime;

    /** 评分说明 */
    @Excel(name = "评分说明")
    private String fScorDesc;

    /** 最后修改时间 */
    @Excel(name = "最后修改时间")
    private String fUpdateTime;

    /** 申报状态：1 已申报，2 未申报，  */
    @Excel(name = "申报状态",dictType = "t_expert_rep_status")
    private Long fRepStatus;

    /** 申报时间 */
    @Excel(name = "申报时间")
    private String fRepDate;

    public void setfProBehInforId(Long fProBehInforId) 
    {
        this.fProBehInforId = fProBehInforId;
    }

    public Long getfProBehInforId() 
    {
        return fProBehInforId;
    }
    public void setfIdNo(String fIdNo) 
    {
        this.fIdNo = fIdNo;
    }

    public String getfIdNo() 
    {
        return fIdNo;
    }

    public String getfName() {
        return fName;
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public void setfExpertEval(String fExpertEval)
    {
        this.fExpertEval = fExpertEval;
    }

    public String getfExpertEval()
    {
        return fExpertEval;
    }
    public void setfSelectionEvent(String fSelectionEvent) 
    {
        this.fSelectionEvent = fSelectionEvent;
    }

    public String getfSelectionEvent() 
    {
        return fSelectionEvent;
    }
    public void setfSelectionStartTime(String fSelectionStartTime) 
    {
        this.fSelectionStartTime = fSelectionStartTime;
    }

    public String getfSelectionStartTime() 
    {
        return fSelectionStartTime;
    }
    public void setfScorDesc(String fScorDesc) 
    {
        this.fScorDesc = fScorDesc;
    }

    public String getfScorDesc() 
    {
        return fScorDesc;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfRepStatus(Long fRepStatus) 
    {
        this.fRepStatus = fRepStatus;
    }

    public Long getfRepStatus() 
    {
        return fRepStatus;
    }
    public void setfRepDate(String fRepDate) 
    {
        this.fRepDate = fRepDate;
    }

    public String getfRepDate() 
    {
        return fRepDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fProBehInforId", getfProBehInforId())
            .append("fIdNo", getfIdNo())
            .append("fExperEval", getfExpertEval())
            .append("fSelectionEvent", getfSelectionEvent())
            .append("fSelectionStartTime", getfSelectionStartTime())
            .append("fScorDesc", getfScorDesc())
            .append("fUpdateTime", getfUpdateTime())
            .append("fRepStatus", getfRepStatus())
            .append("fRepDate", getfRepDate())
            .toString();
    }
}
