package com.zehong.web.controller.task;

import java.util.ArrayList;
import java.util.List;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.service.ITDetectorUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkTaskInspect;
import com.zehong.system.service.ITWorkTaskInspectService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 入户安检Controller
 * 
 * @author zehong
 * @date 2023-09-15
 */
@RestController
@RequestMapping("/system/inspect")
public class TWorkTaskInspectController extends BaseController
{
    @Autowired
    private ITWorkTaskInspectService tWorkTaskInspectService;

    @Autowired
    private ITDetectorUserService tDetectorUserService;

    /**
     * 查询入户安检列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkTaskInspect tWorkTaskInspect)
    {
        startPage();
        List<TWorkTaskInspect> list = tWorkTaskInspectService.selectTWorkTaskInspectList(tWorkTaskInspect);
        return getDataTable(list);
    }
    @GetMapping("/xcxlist")
    public TableDataInfo xcxlist(TWorkTaskInspect tWorkTaskInspect)
    {
        startPage();
        List<TWorkTaskInspect> list = tWorkTaskInspectService.selectTWorkTaskInspectwxList(tWorkTaskInspect);
        return getDataTable(list);
    }
    @GetMapping("/xcxwlist")
    public TableDataInfo xcxwlist(TWorkTaskInspect tWorkTaskInspect)
    {
        startPage();
        List<TDetectorUser> list = tWorkTaskInspectService.selectTWorkTaskInspectwxnotList(tWorkTaskInspect);
        return getDataTable(list);
    }

    /**
     * 导出入户安检列表
     */
    @Log(title = "入户安检", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkTaskInspect tWorkTaskInspect)
    {
        List<TWorkTaskInspect> list = tWorkTaskInspectService.selectTWorkTaskInspectList(tWorkTaskInspect);
        ExcelUtil<TWorkTaskInspect> util = new ExcelUtil<TWorkTaskInspect>(TWorkTaskInspect.class);
        return util.exportExcel(list, "入户安检数据");
    }

    /**
     * 获取入户安检详细信息
     */
    @GetMapping(value = "/{inspectId}")
    public AjaxResult getInfo(@PathVariable("inspectId") Long inspectId)
    {
        return AjaxResult.success(tWorkTaskInspectService.selectTWorkTaskInspectById(inspectId));
    }

    /**
     * 新增入户安检
     */
    @Log(title = "入户安检", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkTaskInspect tWorkTaskInspect)
    {
        Integer t = tWorkTaskInspectService.insertTWorkTaskInspect(tWorkTaskInspect);
        return AjaxResult.success(tWorkTaskInspect);
    }

    /**
     * 修改入户安检
     */
    @Log(title = "入户安检", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkTaskInspect tWorkTaskInspect)
    {
        return toAjax(tWorkTaskInspectService.updateTWorkTaskInspect(tWorkTaskInspect));
    }

    /**
     * 删除入户安检
     */
    @Log(title = "入户安检", businessType = BusinessType.DELETE)
	@DeleteMapping("/{inspectIds}")
    public AjaxResult remove(@PathVariable Long[] inspectIds)
    {
        return toAjax(tWorkTaskInspectService.deleteTWorkTaskInspectByIds(inspectIds));
    }

    /**
     * 入户安检统计
     * @param tWorkTaskInspect 入户安检实体
     * @return
     */
    @GetMapping("/inspectStatistic")
    public AjaxResult inspectStatistic(TWorkTaskInspect tWorkTaskInspect){
        return AjaxResult.success(tWorkTaskInspectService.inspectStatistic(tWorkTaskInspect));
    }

    @GetMapping("/getGasUserInspect")
    public TableDataInfo getGasUserInspect(TDetectorUser tDetectorUser){
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tDetectorUser.setBeyondEnterpriseId(user.getDeptId());
        getHasInspectUser(tDetectorUser);
        startPage();
        List<TDetectorUser> userInfoList = tDetectorUserService.selectTDetectorUserList(tDetectorUser);
        for(TDetectorUser userInfo : userInfoList){
            TWorkTaskInspect tWorkTaskInspect = new TWorkTaskInspect();
            tWorkTaskInspect.setTaskId(tDetectorUser.getTaskId());
            tWorkTaskInspect.setReceiveId(userInfo.getUserId());
            List<TWorkTaskInspect> inspectInfo = tWorkTaskInspectService.selectTWorkTaskInspectList(tWorkTaskInspect);
            if(CollectionUtils.isEmpty(inspectInfo)){
                userInfo.setIsInspect("0");
            }else{
                userInfo.setIsInspect("1");
                userInfo.setInspector(inspectInfo.get(0).getMemberName());
                userInfo.setInspectDate(inspectInfo.get(0).getCreateTime());
                userInfo.setInspectInfo(inspectInfo);
            }
        }
        return getDataTable(userInfoList);
    }

    private void getHasInspectUser(TDetectorUser tDetectorUser){
        if(StringUtils.isNotEmpty(tDetectorUser.getIsInspect())){
            List<Long> userList = tWorkTaskInspectService.getHasInspectByTaskId(tDetectorUser.getTaskId());
            if(CollectionUtils.isEmpty(userList)){
                List<Long> user = new ArrayList<>();
                user.add(-1000L);
                tDetectorUser.setHasInspectUser(user);
            }else{
                tDetectorUser.setHasInspectUser(userList);
            }
        }

    }
}
