package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceUser;
import com.zehong.system.service.ITDeviceUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备用户Controller
 * 
 * @author zehong
 * @date 2023-07-23
 */
@RestController
@RequestMapping("/system/deviceUser")
public class TDeviceUserController extends BaseController
{
    @Autowired
    private ITDeviceUserService tDeviceUserService;

    /**
     * 查询设备用户列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDeviceUser tDeviceUser)
    {
        startPage();
        List<TDeviceUser> list = tDeviceUserService.selectTDeviceUserList(tDeviceUser);
        return getDataTable(list);
    }
    @GetMapping("/allListbyTownship")
    public AjaxResult allListbyTownship()
    {
        startPage();
        List<TDeviceUser> list = tDeviceUserService.allListbyTownship();
        return AjaxResult.success(list);
    }

    /**
     * 导出设备用户列表
     */
    @Log(title = "设备用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceUser tDeviceUser)
    {
        List<TDeviceUser> list = tDeviceUserService.selectTDeviceUserList(tDeviceUser);
        ExcelUtil<TDeviceUser> util = new ExcelUtil<TDeviceUser>(TDeviceUser.class);
        return util.exportExcel(list, "设备用户数据");
    }

    /**
     * 获取设备用户详细信息
     */
    @GetMapping(value = "/{userId}")
    public AjaxResult getInfo(@PathVariable("userId") Long userId)
    {
        return AjaxResult.success(tDeviceUserService.selectTDeviceUserById(userId));
    }

    /**
     * 新增设备用户
     */
    @Log(title = "设备用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceUser tDeviceUser)
    {
        return toAjax(tDeviceUserService.insertTDeviceUser(tDeviceUser));
    }

    /**
     * 修改设备用户
     */
    @Log(title = "设备用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceUser tDeviceUser)
    {
        return toAjax(tDeviceUserService.updateTDeviceUser(tDeviceUser));
    }

    /**
     * 删除设备用户
     */
    @Log(title = "设备用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{userIds}")
    public AjaxResult remove(@PathVariable Long[] userIds)
    {
        return toAjax(tDeviceUserService.deleteTDeviceUserByIds(userIds));
    }
}
