package com.zehong.web.controller.supplybalance;

import java.util.ArrayList;
import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupBalStopSup;
import com.zehong.system.service.ITSupBalStopSupService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 供需平衡-停气监管Controller
 * 
 * @author zehong
 * @date 2024-06-21
 */
@RestController
@RequestMapping("/supplyBalance/stop")
public class TSupBalStopSupController extends BaseController
{
    @Autowired
    private ITSupBalStopSupService tSupBalStopSupService;

    /**
     * 查询供需平衡-停气监管列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupBalStopSup tSupBalStopSup)
    {
        startPage();
        if(!"-2".equals(SecurityUtils.getLoginUser().getUser().getDeptId())){
            tSupBalStopSup.setfCompanyInfoId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }else{
            tSupBalStopSup.setfRepStatus("1");
        }
        List<TSupBalStopSup> list = tSupBalStopSupService.selectTSupBalStopSupList(tSupBalStopSup);
        return getDataTable(list);
    }

    /**
     * 导出供需平衡-停气监管列表
     */
    @Log(title = "供需平衡-停气监管", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupBalStopSup tSupBalStopSup)
    {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if(loginUser.getUser().getRoles().get(0).getRoleId()==5){
            tSupBalStopSup.setfCompanyInfoId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }else{
            tSupBalStopSup.setfRepStatus("1");
        }
        List<TSupBalStopSup> list = tSupBalStopSupService.selectTSupBalStopSupList(tSupBalStopSup);
        ExcelUtil<TSupBalStopSup> util = new ExcelUtil<TSupBalStopSup>(TSupBalStopSup.class);
        if(loginUser.getUser().getRoles().get(0).getRoleId()==5){
//            List<String> columns = new ArrayList<>();
//            columns.add("fRepStatus");
//            columns.add("entRepTime");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(12);
            ExcelUtil.hiddencolumns.add(13);
        }else{
//            List<String> columns = new ArrayList<>();
//            columns.add("fGovUploadStatus");
//            columns.add("fGovUploadTime");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(8);
            ExcelUtil.hiddencolumns.add(9);
        }
        AjaxResult ajaxResult = util.exportExcel(list, "供需平衡-停气监管数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取供需平衡-停气监管详细信息
     */
    @GetMapping(value = "/{fGasStopId}")
    public AjaxResult getInfo(@PathVariable("fGasStopId") Long fGasStopId)
    {
        return AjaxResult.success(tSupBalStopSupService.selectTSupBalStopSupById(fGasStopId));
    }

    /**
     * 新增供需平衡-停气监管
     */
    @Log(title = "供需平衡-停气监管", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupBalStopSup tSupBalStopSup)
    {
        return toAjax(tSupBalStopSupService.insertTSupBalStopSup(tSupBalStopSup));
    }

    /**
     * 修改供需平衡-停气监管
     */
    @Log(title = "供需平衡-停气监管", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupBalStopSup tSupBalStopSup)
    {
        return toAjax(tSupBalStopSupService.updateTSupBalStopSup(tSupBalStopSup));
    }

    /**
     * 删除供需平衡-停气监管
     */
    @Log(title = "供需平衡-停气监管", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fGasStopIds}")
    public AjaxResult remove(@PathVariable Long[] fGasStopIds)
    {
        return toAjax(tSupBalStopSupService.deleteTSupBalStopSupByIds(fGasStopIds));
    }

    /**
     * 上传停气监管记录
     * @param fGasStopId 停气监管记录主键
     * @return
     */
    @GetMapping("/reportSupBalStopSupRecInfo")
    public AjaxResult reportSupBalStopSupRecInfo(Long fGasStopId){
        try{
            return toAjax(tSupBalStopSupService.reportSupBalStopSupRecInfo(fGasStopId));
        }catch (Exception e){
            logger.error("上传停气监管记录接口异常=====",e);
            return AjaxResult.error("上传停气监管记录接口异常");
        }
    }

    /**
     * 改变停气状态
     * @param tSupBalStopSup
     * @return
     */
    @PostMapping("/changeStopStatus")
    public AjaxResult changeStopStatus(@RequestBody TSupBalStopSup tSupBalStopSup) {
        return toAjax(tSupBalStopSupService.changeStopStatus(tSupBalStopSup));
    }
}
