package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsInsListInfor;
import com.zehong.system.service.ITInsInsListInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-获取检查项Controller
 * 
 * @author zehong
 * @date 2024-05-17
 */
@RestController
@RequestMapping("/supervision/inspect")
public class TInsInsListInforController extends BaseController
{
    @Autowired
    private ITInsInsListInforService tInsInsListInforService;

    /**
     * 查询监督检查-获取检查项列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsInsListInfor tInsInsListInfor)
    {
        startPage();
        List<TInsInsListInfor> list = tInsInsListInforService.selectTInsInsListInforList(tInsInsListInfor);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-获取检查项列表
     */
    @Log(title = "监督检查-获取检查项", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsInsListInfor tInsInsListInfor)
    {
        List<TInsInsListInfor> list = tInsInsListInforService.selectTInsInsListInforList(tInsInsListInfor);
        ExcelUtil<TInsInsListInfor> util = new ExcelUtil<TInsInsListInfor>(TInsInsListInfor.class);
        return util.exportExcel(list, "监督检查-获取检查项数据");
    }

    /**
     * 获取监督检查-获取检查项详细信息
     */
    @GetMapping(value = "/{fInsInsListInforId}")
    public AjaxResult getInfo(@PathVariable("fInsInsListInforId") Long fInsInsListInforId)
    {
        return AjaxResult.success(tInsInsListInforService.selectTInsInsListInforById(fInsInsListInforId));
    }

    /**
     * 新增监督检查-获取检查项
     */
    @Log(title = "监督检查-获取检查项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsInsListInfor tInsInsListInfor)
    {
        return toAjax(tInsInsListInforService.insertTInsInsListInfor(tInsInsListInfor));
    }

    /**
     * 修改监督检查-获取检查项
     */
    @Log(title = "监督检查-获取检查项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsInsListInfor tInsInsListInfor)
    {
        return toAjax(tInsInsListInforService.updateTInsInsListInfor(tInsInsListInfor));
    }

    /**
     * 删除监督检查-获取检查项
     */
    @Log(title = "监督检查-获取检查项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsInsListInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsInsListInforIds)
    {
        return toAjax(tInsInsListInforService.deleteTInsInsListInforByIds(fInsInsListInforIds));
    }
}
