package com.zehong.web.controller.supervise;
import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TTSiteStationInfoList;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.system.service.ITEmployedPeopleInfoService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSiteStationInfo;
import com.zehong.system.service.ITSiteStationInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 场站信息Controller
 *
 * @author zehong
 * @date 2022-01-27
 */
@RestController
@RequestMapping("/supervise/station")
public class TSiteStationInfoController extends BaseController {
    @Autowired
    private ITSiteStationInfoService tSiteStationInfoService;

    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    @Autowired
    private ITDeviceInfoService tDeviceInfoService;

    /**
     * 查询场站信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSiteStationInfo tSiteStationInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tSiteStationInfo.setBeyondEnterpriseId(user.getDeptId());
        startPage();
        List<TSiteStationInfo> list = tSiteStationInfoService.selectTSiteStationInfoList(tSiteStationInfo);
        return getDataTable(list);
    }

    /**
     * 导出场站信息列表
     */
    @Log(title = "场站信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSiteStationInfo tSiteStationInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tSiteStationInfo.setBeyondEnterpriseId(user.getDeptId());
        List<TSiteStationInfo> list = tSiteStationInfoService.selectTSiteStationInfoList(tSiteStationInfo);
        ExcelUtil<TSiteStationInfo> util = new ExcelUtil<TSiteStationInfo>(TSiteStationInfo.class);
        return util.exportExcel(list, "场站信息数据");
    }

    /**
     * 获取场站信息详细信息
     */
    @GetMapping(value = "/{siteStationId}")
    public AjaxResult getInfo(@PathVariable("siteStationId") Long siteStationId)
    {
        return AjaxResult.success(tSiteStationInfoService.selectTSiteStationInfoById(siteStationId));
    }

    /**
     * 新增场站信息
     */
    @Log(title = "场站信息", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@RequestBody TTSiteStationInfoList tSiteStationInfos)
    {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tSiteStationInfos.gettDeviceInfo().getBeyondEnterpriseId());
        tSiteStationInfos.gettDeviceInfo().setBeyondEnterpriseName(EnterpriseName);
        tSiteStationInfoService.insertTSiteStationInfo(tSiteStationInfos.gettDeviceInfo());
        if (CollectionUtils.isNotEmpty(tSiteStationInfos.gettDeviceInfoS())){
            //将关联设备信息与设备进行绑定
            tDeviceInfoService.updatetRelationDeviceDetailInfo(tSiteStationInfos.gettDeviceInfoS(),tSiteStationInfos.gettDeviceInfo().getSiteStationId(),tSiteStationInfos.gettDeviceInfo().getRelationDeviceType());
        }
    }

    /**
     * 修改场站信息
     */
    @Log(title = "场站信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSiteStationInfo tSiteStationInfo)
    {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tSiteStationInfo.getBeyondEnterpriseId());
        tSiteStationInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tSiteStationInfoService.updateTSiteStationInfo(tSiteStationInfo));
    }

    /**
     * 删除场站信息
     */
    @Log(title = "场站信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{siteStationIds}")
    public AjaxResult remove(@PathVariable Long[] siteStationIds)
    {
        return toAjax(tSiteStationInfoService.deleteTSiteStationInfoByIds(siteStationIds));
    }
}
