package com.zehong.web.controller.supervise;

import java.util.List;

import com.zehong.system.domain.TDetailInfoList;
import com.zehong.system.domain.TDeviceInfoS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TGasuserSafetyDeviceInfo;
import com.zehong.system.service.ITGasuserSafetyDeviceInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 用户管理-燃气用户-安全装置加装维护Controller
 * 
 * @author zehong
 * @date 2024-08-27
 */
@RestController
@RequestMapping("/gasUserSafetyDevice/info")
public class TGasuserSafetyDeviceInfoController extends BaseController
{
    @Autowired
    private ITGasuserSafetyDeviceInfoService tGasuserSafetyDeviceInfoService;

    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        startPage();
        List<TGasuserSafetyDeviceInfo> list = tGasuserSafetyDeviceInfoService.selectTGasuserSafetyDeviceInfoList(tGasuserSafetyDeviceInfo);
        return getDataTable(list);
    }

    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    @RequestMapping("/queryNoSelectSafeDeviceInfoList")
    public TableDataInfo queryNoSelectSafeDeviceInfoList(@RequestBody TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo){
        List<TGasuserSafetyDeviceInfo> tGasuserSafetyDeviceInfos = tGasuserSafetyDeviceInfoService.queryNoSelectSafeDeviceInfoList(tGasuserSafetyDeviceInfo);
        return getDataTable(tGasuserSafetyDeviceInfos);
    }

    /**
     * 导出用户管理-燃气用户-安全装置加装维护列表
     */
    @Log(title = "用户管理-燃气用户-安全装置加装维护", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        List<TGasuserSafetyDeviceInfo> list = tGasuserSafetyDeviceInfoService.queryNoSelectSafeDeviceInfoList(tGasuserSafetyDeviceInfo);
        ExcelUtil<TGasuserSafetyDeviceInfo> util = new ExcelUtil<TGasuserSafetyDeviceInfo>(TGasuserSafetyDeviceInfo.class);
        return util.exportExcel(list, "用户管理-燃气用户-安全装置加装维护数据");
    }

    /**
     * 获取用户管理-燃气用户-安全装置加装维护详细信息
     */
    @GetMapping(value = "/{gasUserSafetyDeviceId}")
    public AjaxResult getInfo(@PathVariable("gasUserSafetyDeviceId") Long gasUserSafetyDeviceId)
    {
        return AjaxResult.success(tGasuserSafetyDeviceInfoService.selectTGasuserSafetyDeviceInfoById(gasUserSafetyDeviceId));
    }

    /**
     * 新增用户管理-燃气用户-安全装置加装维护
     */
    @Log(title = "用户管理-燃气用户-安全装置加装维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        return toAjax(tGasuserSafetyDeviceInfoService.insertTGasuserSafetyDeviceInfo(tGasuserSafetyDeviceInfo));
    }

    /**
     * 修改用户管理-燃气用户-安全装置加装维护
     */
    @Log(title = "用户管理-燃气用户-安全装置加装维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        return toAjax(tGasuserSafetyDeviceInfoService.updateTGasuserSafetyDeviceInfo(tGasuserSafetyDeviceInfo));
    }

    /**
     * 删除用户管理-燃气用户-安全装置加装维护
     */
    @Log(title = "用户管理-燃气用户-安全装置加装维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{gasUserSafetyDeviceIds}")
    public AjaxResult remove(@PathVariable Long[] gasUserSafetyDeviceIds)
    {
        return toAjax(tGasuserSafetyDeviceInfoService.deleteTGasuserSafetyDeviceInfoByIds(gasUserSafetyDeviceIds));
    }


    /**
     * 关联安装加装装置 批量删除
     * @param safetyDetailIds s
     */
    @RequestMapping("/deleteSafetyDeviceListInfo")
    public void deleteSafetyDeviceListInfo(@RequestBody Long[] safetyDetailIds){
        tGasuserSafetyDeviceInfoService.deleteSafetyDeviceListInfo(safetyDetailIds);
    }

    /**
     * 关联安装加装装置 单条删除
     * @param safetyDetailId i
     */
    @RequestMapping("/deleteSafetyDeviceInfo")
    public void deleteSafetyDeviceInfo(@RequestBody Long safetyDetailId){
        tGasuserSafetyDeviceInfoService.deleteSafetyDeviceInfo(safetyDetailId);
    }


    /**
     * 根据 燃气用户id 查询集合数据
     * @param userId i
     */
    @GetMapping("/selectSafetyDeviceDetailInfoList/{userId}")
    public AjaxResult selectSafetyDeviceDetailInfoList(@PathVariable("userId") Long userId){
       return AjaxResult.success(tGasuserSafetyDeviceInfoService.selectSafetyDeviceDetailInfoList(userId));
    }

}
