package com.zehong.web.controller.supervise;

import java.io.File;
import java.util.List;
import java.util.Map;

import com.zehong.common.config.GassafetyProgressConfig;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.*;
import com.zehong.system.service.*;
import com.zehong.web.codeconfig.CodeConFig;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.weaver.loadtime.Aj;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.annotation.Resource;

/**
 * 设备信息Controller
 *
 * @author zehong
 * @date 2022-01-27
 */
@RestController
@RequestMapping("/device/device")
public class TDeviceInfoController extends BaseController
{
    @Autowired
    private ITDeviceInfoService tDeviceInfoService;

    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    @Autowired
    private ITDetectorInfoService  itDetectorInfoService;
    @Autowired
    private ITDetectorUserService itDetectorUserService;
    @Autowired
    private TokenService tokenService;

    @Resource
    private ITDeviceUserService tDeviceUserService;

    /**
     * 查询设备信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDeviceInfo tDeviceInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tDeviceInfo.setBeyondEnterpriseId(user.getDeptId());
        startPage();
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return getDataTable(list);
    }

    /**
     *
     * 大屏端 全局搜素 设备，场站，用户信息，监控 步骤一
     * */
    @GetMapping("/queryBasicInforByNameForBigWindows")
    public  AjaxResult queryBasicInforByNameForBigWindows(String name) {
        return AjaxResult.success(tDeviceInfoService.queryBasicInforByNameForBigWindows(name));
    }

    /**
     *
     * 大屏端 全局搜素 设备，场站，用户信息，监控 步骤二
     * */
    @GetMapping("/queryBasicInforByTypeAndIdForBigWindows")
    public AjaxResult queryBasicInforByTypeAndIdForBigWindows(String type,String id) {
        return AjaxResult.success(tDeviceInfoService.queryBasicInforByTypeAndIdForBigWindows(type,id));
    }

    @GetMapping("/alllist")
    public AjaxResult alllist(TDeviceInfo tDeviceInfo)
    {
        List<TDeviceInfo> list = tDeviceInfoService.selectDeviceList(tDeviceInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出设备信息列表
     */
    @Log(title = "设备信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceInfo tDeviceInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tDeviceInfo.setBeyondEnterpriseId(user.getDeptId());
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        return util.exportExcel(list, "设备信息数据");
    }

    /**
     * 获取设备信息详细信息
     */
    @GetMapping(value = "/{deviceId}")
    public AjaxResult getInfo(@PathVariable("deviceId") Long deviceId)
    {
        return AjaxResult.success(tDeviceInfoService.selectTDeviceInfoById(deviceId));
    }

    /**
     * 新增设备信息
     */
    @Log(title = "设备信息", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@RequestBody Listaw listaw)
    {
        //生成四位随机码
        String code = CodeConFig.RandomCode();
        String intFlag = String.valueOf((int)(Math.random() * 1000000));
        listaw.gettDeviceInfo().setDeviceCode(intFlag);
        //添加设备信息表数据 并且返回新增id
        tDeviceInfoService.insertTDeviceInfo(listaw.gettDeviceInfo());
        if (CollectionUtils.isNotEmpty(listaw.gettDeviceInfoS())){
            //将关联设备信息与设备进行绑定
            tDeviceInfoService.updatetRelationDeviceDetailInfo(listaw.gettDeviceInfoS(),listaw.gettDeviceInfo().getDeviceId(),listaw.gettDeviceInfo().getRelationDeviceType());
        }
        TDeviceInfo tDeviceInfo = new TDeviceInfo();
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tDeviceInfo.getBeyondEnterpriseId());
        tDeviceInfo.setBeyondEnterpriseName(EnterpriseName);
    }

    /**
     * 修改设备信息
     */
    @Log(title = "设备信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceInfo tDeviceInfo)
    {
        TDeviceInfo tDeviceInfos = tDeviceInfoService.selectTDeviceInfoById(tDeviceInfo.getDeviceId());
        //文件删除 20240731 wh 调整去掉删除
//        if (tDeviceInfos.getIconUrl()!=null){
//            // 上传文件路径
//            String filePath = GassafetyProgressConfig.getUploadPath();
//            String[] strs = tDeviceInfos.getIconUrl().split("upload");
//            //删除图片
//            File file = new File(filePath+strs[1].toString());
//            // 上传文件路径
//            if(file.isFile()){
//                file.delete();
//            }
//        }
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tDeviceInfo.getBeyondEnterpriseId());
        tDeviceInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tDeviceInfoService.updateTDeviceInfo(tDeviceInfo));
    }

    /**
     * 删除设备信息
     */
    @Log(title = "设备信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deviceIds}")
    public AjaxResult remove(@PathVariable Long[] deviceIds)
    {
        return toAjax(tDeviceInfoService.deleteTDeviceInfoByIds(deviceIds));
    }


    /**
     * 获取设备详细信息列表
     */
    @GetMapping("/getdeviceDetailInfo")
    public AjaxResult getdeviceDetailInfo(Long deviceId) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.getdeviceDetailInfo(deviceId);
        return AjaxResult.success(tDeviceInfoS);
    }


    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    @RequestMapping("/selectDetailInfo")
    public TableDataInfo selectDetailInfo(@RequestBody  TDeviceInfoS tDeviceInfos){
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.selectDetailInfo(tDeviceInfos);
        return getDataTable(tDeviceInfoS);
    }

    /**
     * 添加关联设备数据接口
     */
    @RequestMapping("/insertDetailInfo")
    public void insertDetailInfo(@RequestBody TDeviceInfoS tDeviceInfoS){
        //添加关联设备信息表数据
        tDeviceInfoService.insertDeviceDetailInfo(tDeviceInfoS);
    }

    /**
     * 关联设备数据删除接口
     */
    @RequestMapping("/deleteDetailInfo")
    public void deleteDetailInfo(@RequestBody  int deviceId){
        tDeviceInfoService.deleteDetailinfOS(deviceId);
    }

    /**
     * 解绑 设备与关联设备关系
     * @param deviceId
     */
    @RequestMapping("/deleteDeviceDetailInfo")
    public void  deleteDeviceDetailInfo(@RequestBody int deviceId){
        tDeviceInfoService.deleteDeviceDetailInfo(deviceId);
    }

    /**
     * 关联设备批量数据删除接口
     * @param deviceId
     */
    @RequestMapping("/deleteeListDetailInfo")
    public void deleteeListDetailInfo(@RequestBody  Long[] deviceId){
        tDeviceInfoService.deleteDetailInfo(deviceId);
    }


    /**
     * 查询设备已经关联的关联设备接口
     * @param tDetailInfoList
     * @return
     */
    @RequestMapping("/selectDetailInfoList")
    public TableDataInfo selectDetailInfoList(@RequestBody TDetailInfoList tDetailInfoList){
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.selectDetailInfoList(tDetailInfoList.getId(),tDetailInfoList.getRelationDeviceType());
        return getDataTable(tDeviceInfoS);
    }

    /**
     * 关联设备绑定接口
     * @param listaw
     */
    @RequestMapping("/updateDetailInfoList")
    public void updateDetailInfoList(@RequestBody Listaw listaw){
        Long id;
        if (null!=listaw.gettDeviceInfo().getDeviceId()){
            id=listaw.gettDeviceInfo().getDeviceId();
        }else {
            id=listaw.gettDeviceInfo().getSiteStationId();
        }
        if (!"null".equals(listaw.gettDeviceInfoS())){
            //将关联设备信息与设备进行绑定
            tDeviceInfoService.updatetRelationDeviceDetailInfo(listaw.gettDeviceInfoS(),id,listaw.gettDeviceInfo().getRelationDeviceType());
        }
    }

    @GetMapping("/selectDeviceNum")
    public AjaxResult selectDeviceNum(String enterpriseId)
    {
        /**
         * 判断是否是政府单位登录 如果不是 就只查询出本企业下面的数据
         */
        //获取当前登录用户信息
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
//            user.setDeptId((long) 0);
        }else {
            enterpriseId= String.valueOf(user.getDeptId());
        }
        Map<String,Object> map = itDetectorInfoService.selectDetectorNum(enterpriseId);
        Map<String,Object> map1 =tDeviceInfoService.selectDeviceNum(enterpriseId);
        Map<String,Object> map2 =itDetectorUserService.selectUserNum();
        map.putAll(map2);
        map.putAll(map1);
        return  AjaxResult.success(map);
    }
}
