package com.zehong.web.controller.supervise;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.*;
import com.zehong.system.service.IPipeInterfaceService;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.ArrayList;
import java.util.List;

/**
 * 管道信息接口控制层
 */
@Controller
@RestController
@RequestMapping("/pipe/pipe")
public class PipeInterfaceController extends BaseController {

    @Autowired
    IPipeInterfaceService iPipeInterfaceService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询管道数据列表
     */
    @RequestBody
    @RequestMapping("/getPipeForSelect")
    public PipeList getPipeForSelect() {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();

        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //查询管道数据列表
        List<PipeDate> pipeDates = iPipeInterfaceService.getPipeForSelect(String.valueOf(user.getDeptId()));
        PipeList pipeList=new PipeList();
        pipeList.setData(pipeDates);
        return pipeList;
    }


    /**
     * 查询管道数据列表
     */
    @RequestBody
    @RequestMapping("/selectPipeData")
    public PipeList selectPipeData() {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        //获取分组数据
        List<PipeDate> pipeDatesGroup = iPipeInterfaceService.selectGroupPipeData();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //查询管道数据列表
        List<PipeDate> pipeDates = iPipeInterfaceService.selectPipeData(String.valueOf(user.getDeptId()));
        int k=1;
        //循环根据权属单位名称分组的数据
        for (int i=0;i<pipeDatesGroup.size();i++){
             //循环全部数据
//            for (int n=0;n<pipeDates.size();n++){
//                //判断如果名称一样就一组
//                if (pipeDatesGroup.get(i).getPowerCompany().equals(pipeDates.get(n).getPowerCompany())){
////                    //设置分组类型
////                    pipeDates.get(n).setCompanyType(Integer.parseInt(pipeDates.get(n).getPipeId()));
//                    pipeDates.get(n).setIconType(1);
//                }
//            }
            k++;
        }
        PipeList pipeList=new PipeList();
        pipeList.setData(pipeDates);
        return pipeList;
    }


    /**
     * 调压箱数据查询接口   使用中
     * @return
     */
    @RequestBody
    @RequestMapping("/selectDeviceData")
    public DeviceList selectDeviceDatas(){
        //最后返回的封装类型
        DeviceList deviceList=new DeviceList();
        List<DeviceData> list=new ArrayList<>();


        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //调压箱数据查询方法
        List<DeviceData> deviceData = iPipeInterfaceService.selectDeviceData(user.getDeptId());
//        //查询下级全部数据方法
//        List<PressureFlow> pressureFlows1 = iPipeInterfaceService.selectPressureFlows("1");
//        for (int i=0;i<deviceData.size();i++){
//            boolean bo=false;
//            for (int s=0;s<pressureFlows1.size();s++){
//                if (pressureFlows1.get(s).getDeviceId().equals(deviceData.get(i).getDeviceId())){
//                    bo=true;
//                    break;
//                 }
//              }
//            if (bo){
//                deviceData.get(i).setIconType(2);
//                list.add(deviceData.get(i));
//            }
//         }
        for (int i=0;i<deviceData.size();i++){
            deviceData.get(i).setIconType(2);
            list.add(deviceData.get(i));
        }
        deviceList.setData(list);
        return deviceList;
    }



    /**
     * 查询下级设备关联数据接口
     * @param deviceId
     * @return
     */
    @RequestBody
    @RequestMapping("/selectPressureFlow")
    public DeviceList selectPressureFlow(String deviceId){
        //最后返回的封装类型
        DeviceList deviceList=new DeviceList();
        List<DeviceData> DeviceList=new ArrayList<>();
        //查询关联设备下级数据方法
        List<PressureFlow> pressureFlows = iPipeInterfaceService.selectPressureFlow(deviceId);
        //临时存储压力表数据数组
        List<PressureFlow> pressureList=new ArrayList<>();
        //临时存储流量计数据数组
        List<PressureFlow> flowmeterList=new ArrayList<>();
        //临时存储探测器数据数组
        List<PressureFlow> detectorList=new ArrayList();
        /**循环下级全部数据*/
        for (int s=0;s<pressureFlows.size();s++){
                //判断是压力表还是流量计   1压力表  2流量计 3探测器
                if (pressureFlows.get(s).getDeviceType().equals("1")){
                    pressureList.add(pressureFlows.get(s));
                }else if (pressureFlows.get(s).getDeviceType().equals("2")){
                    flowmeterList.add(pressureFlows.get(s));
                }else if (pressureFlows.get(s).getDeviceType().equals("3")){
                    detectorList.add(pressureFlows.get(s));
                }
        }
        //创建下级数据list数组
        List<SubordinateEquipmentList> subordinateEquipmentLists=new ArrayList<>();
        /**循环三次  每次代表 1压力表  2流量计  3探测器*/
        for (int t=0;t<3;t++){
            SubordinateEquipmentList subordinateEquipmentList=new SubordinateEquipmentList();
            if (t==0){  /**添加压力表数据*/
                if (pressureList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(pressureList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(pressureList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(pressureList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(pressureList.size());
                }
                subordinateEquipmentList.setDataType(1);
            }else if (t==1){  /**添加流量计数据*/
                if (flowmeterList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(flowmeterList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(flowmeterList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(flowmeterList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(flowmeterList.size());
                }
                subordinateEquipmentList.setDataType(2);
            }else if (t==2){  /**添加探测器数据*/
                if (detectorList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(detectorList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(detectorList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(detectorList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(detectorList.size());
                }
                subordinateEquipmentList.setDataType(3);
            }
            subordinateEquipmentLists.add(subordinateEquipmentList);
        }
        DeviceData deviceData=new DeviceData();
        deviceData.setSubordinateEquipmentList(subordinateEquipmentLists);
        DeviceList.add(deviceData);
        deviceList.setData(DeviceList);
        return deviceList;
    }

    /**
     * 调压箱数据查询接口
     */
    @RequestBody
    @RequestMapping("/selectDeviceDatas")
    public DeviceList  selectDeviceData(){

        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //调压箱数据查询方法
        List<DeviceData> deviceData = iPipeInterfaceService.selectDeviceData(user.getDeptId());
        //查询下级全部数据方法
        List<PressureFlow> pressureFlows1 = iPipeInterfaceService.selectPressureFlow("1");
        //最后返回的封装类型
        DeviceList deviceList=new DeviceList();
        /**循环调压箱数据*/
        for (int i=0;i<deviceData.size();i++){
            //创建下级数据list数组
            List<SubordinateEquipmentList> subordinateEquipmentLists=new ArrayList<>();
            //临时存储压力表数据数组
            List<PressureFlow> pressureList=new ArrayList<>();
            //临时存储流量计数据数组
            List<PressureFlow> flowmeterList=new ArrayList<>();
            //临时存储探测器数据数组
            List<PressureFlow> detectorList=new ArrayList();
          /**循环下级全部数据*/
          for (int s=0;s<pressureFlows1.size();s++){
              /**判断调压箱id与下级数据调压箱id是否相等*/
              if (pressureFlows1.get(s).getDeviceId().equals(deviceData.get(i).getDeviceId())){
                  //判断是压力表还是流量计   1压力表  2流量计 3探测器
                    if (pressureFlows1.get(s).getDeviceType().equals("1")){
                        pressureList.add(pressureFlows1.get(s));
                    }else if (pressureFlows1.get(s).getDeviceType().equals("2")){
                        flowmeterList.add(pressureFlows1.get(s));
                    }else if (pressureFlows1.get(s).getDeviceType().equals("3")){
                        detectorList.add(pressureFlows1.get(s));
                    }
                }
              }
          /**循环三次  每次代表 1压力表  2流量计  3探测器*/
             for (int t=0;t<3;t++){
                 SubordinateEquipmentList subordinateEquipmentList=new SubordinateEquipmentList();
                 if (t==0){  /**添加压力表数据*/
                    if (pressureList.size()!=0){
                        /**查询下级在线设备数量*/
                       int onLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 0);
                       subordinateEquipmentList.setOnlineEquipment(onLine);
                        /**查询下级离线设备数量*/
                       int offLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 1);
                       subordinateEquipmentList.setOfflineEquipment(offLine);
                        /**查询历史报警数量*/
                        int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(pressureList);
                        subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                        /**查询已处理报警*/
                        int processAlarm = iPipeInterfaceService.selectProcessAlarm(pressureList);
                        subordinateEquipmentList.setAlarmProcessed(processAlarm);
                        /**查询报警中*/
                        int inAlarm = iPipeInterfaceService.selectInAlarm(pressureList);
                        subordinateEquipmentList.setInAlarm(inAlarm);
                        subordinateEquipmentList.setNumberPressureGauges(pressureList.size());
                    }
                     subordinateEquipmentList.setDataType(1);
                 }else if (t==1){  /**添加流量计数据*/
                      if (flowmeterList.size()!=0){
                          /**查询下级在线设备数量*/
                          int onLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 0);
                          subordinateEquipmentList.setOnlineEquipment(onLine);
                          /**查询下级离线设备数量*/
                          int offLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 1);
                          subordinateEquipmentList.setOfflineEquipment(offLine);
                          /**查询历史报警数量*/
                          int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(flowmeterList);
                          subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                          /**查询已处理报警*/
                          int processAlarm = iPipeInterfaceService.selectProcessAlarm(flowmeterList);
                          subordinateEquipmentList.setAlarmProcessed(processAlarm);
                          /**查询报警中*/
                          int inAlarm = iPipeInterfaceService.selectInAlarm(flowmeterList);
                          subordinateEquipmentList.setInAlarm(inAlarm);
                          subordinateEquipmentList.setNumberPressureGauges(flowmeterList.size());
                      }
                     subordinateEquipmentList.setDataType(2);
                 }else if (t==2){  /**添加探测器数据*/
                      if (detectorList.size()!=0){
                          /**查询下级在线设备数量*/
                          int onLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 0);
                          subordinateEquipmentList.setOnlineEquipment(onLine);
                          /**查询下级离线设备数量*/
                          int offLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 1);
                          subordinateEquipmentList.setOfflineEquipment(offLine);
                          /**查询历史报警数量*/
                          int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(detectorList);
                          subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                          /**查询已处理报警*/
                          int processAlarm = iPipeInterfaceService.selectProcessAlarm(detectorList);
                          subordinateEquipmentList.setAlarmProcessed(processAlarm);
                          /**查询报警中*/
                          int inAlarm = iPipeInterfaceService.selectInAlarm(detectorList);
                          subordinateEquipmentList.setInAlarm(inAlarm);
                          subordinateEquipmentList.setNumberPressureGauges(detectorList.size());
                      }
                     subordinateEquipmentList.setDataType(3);
                 }
                 subordinateEquipmentLists.add(subordinateEquipmentList);
             }
            deviceData.get(i).setSubordinateEquipmentList(subordinateEquipmentLists);
          }
        deviceList.setData(deviceData);
        return deviceList;
    }


    /**
     * 场站信息查询接口   使用中
     * @return
     */
    @RequestBody
    @RequestMapping("/selectTSiteStationInfoData")
    public TSiteStationInfoDataList selectTSiteStationInfoData(){
        TSiteStationInfoDataList tSiteStationInfoDataList=new TSiteStationInfoDataList();
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //场站信息查询方法
        List<TSiteStationInfoData> tSiteStationInfoData = iPipeInterfaceService.selectTSiteStationInfoData(user.getDeptId());
        List<TSiteStationInfoData> list=new ArrayList<>();
//        //查询下级全部数据方法
//        List<PressureFlow> pressureFlows1 = iPipeInterfaceService.selectPressureFlows("2");
//        for (int i=0;i<tSiteStationInfoData.size();i++){
//            boolean bo=false;
//            for (int s=0;s<pressureFlows1.size();s++){
//              if (pressureFlows1.get(s).getDeviceId()!=null){
//                  if (pressureFlows1.get(s).getDeviceId().equals(tSiteStationInfoData.get(i).getSiteStationId())){
//                      bo=true;
//                      break;
//                  }
//              }
//            }
//            if (bo){
//                tSiteStationInfoData.get(i).setIconType(4);
//                list.add(tSiteStationInfoData.get(i));
//            }
//        }

        for (int i=0;i<tSiteStationInfoData.size();i++){
            tSiteStationInfoData.get(i).setIconType(4);
            list.add(tSiteStationInfoData.get(i));
        }
        tSiteStationInfoDataList.setData(list);
        return tSiteStationInfoDataList;
    }

    /**
     * 查询场站下级设备关联数据接口
     * @param deviceId
     * @return
     */
    @RequestBody
    @RequestMapping("/selecttSiteStationInfoData")
    public TSiteStationInfoDataList selecttSiteStationInfoData(String deviceId){
        TSiteStationInfoDataList tSiteStationInfoDataList = new TSiteStationInfoDataList();
        List<TSiteStationInfoData> TSiteStationInfoDataList=new ArrayList<>();
        //查询场站下级设备数据
        List<PressureFlow> pressureFlows = iPipeInterfaceService.selecttSiteStationInfoDataList(deviceId);
        //临时存储压力表数据数组
        List<PressureFlow> pressureList=new ArrayList<>();
        //临时存储流量计数据数组
        List<PressureFlow> flowmeterList=new ArrayList<>();
        //临时存储探测器数据数组
        List<PressureFlow> detectorList=new ArrayList();
        /**循环下级全部数据*/
        for (int s=0;s<pressureFlows.size();s++){
            //判断是压力表还是流量计   1压力表  2流量计 3探测器
            if (pressureFlows.get(s).getDeviceType().equals("1")){
                pressureList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("2")){
                flowmeterList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("3")){
                detectorList.add(pressureFlows.get(s));
            }
        }
        //创建下级数据list数组
        List<SubordinateEquipmentList> subordinateEquipmentLists=new ArrayList<>();
        /**循环三次  每次代表 1压力表  2流量计  3探测器*/
        for (int t=0;t<3;t++){
            SubordinateEquipmentList subordinateEquipmentList=new SubordinateEquipmentList();
            if (t==0){  /**添加压力表数据*/
                if (pressureList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(pressureList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(pressureList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(pressureList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(pressureList.size());
                }
                subordinateEquipmentList.setDataType(1);
            }else if (t==1){  /**添加流量计数据*/
                if (flowmeterList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(flowmeterList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(flowmeterList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(flowmeterList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(flowmeterList.size());
                }
                subordinateEquipmentList.setDataType(2);
            }else if (t==2){  /**添加探测器数据*/
                if (detectorList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(detectorList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(detectorList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(detectorList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(detectorList.size());
                }
                subordinateEquipmentList.setDataType(3);
            }
            subordinateEquipmentLists.add(subordinateEquipmentList);
        }
        TSiteStationInfoData deviceData=new TSiteStationInfoData();
        deviceData.setSubordinateEquipmentList(subordinateEquipmentLists);
        TSiteStationInfoDataList.add(deviceData);
        tSiteStationInfoDataList.setData(TSiteStationInfoDataList);
        return tSiteStationInfoDataList;
    }

    /**
     * 场站信息查询接口
     */
    @RequestBody
    @RequestMapping("/selectTSiteStationInfoDatas")
    public TSiteStationInfoDataList selectTSiteStationInfoDatas(){
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //场站信息查询方法
        List<TSiteStationInfoData> tSiteStationInfoData = iPipeInterfaceService.selectTSiteStationInfoData(user.getDeptId());
        //查询场站下级设备数据
        List<PressureFlow> pressureFlows = iPipeInterfaceService.selecttSiteStationInfoDataList("1");
        TSiteStationInfoDataList tSiteStationInfoDataList=new TSiteStationInfoDataList();
        for (int i=0;i<tSiteStationInfoData.size();i++){
            //临时存储压力表数据数组
            List<PressureFlow> pressureList=new ArrayList<>();
            //临时存储流量计数据数组
            List<PressureFlow> flowmeterList=new ArrayList<>();
            //临时存储探测器数据数组
            List<PressureFlow> detectorList=new ArrayList();
            //存储全部数据
            List<PressureFlow> List=new ArrayList<>();
            for (int s=0;s<pressureFlows.size();s++){
                 if (tSiteStationInfoData.get(i).getSiteStationId()==pressureFlows.get(s).getDeviceId()){
                     List.add(pressureFlows.get(s));
                     //判断是压力表还是流量计   1压力表  2流量计  3探测器
                     if (pressureFlows.get(s).getDeviceType()=="1"){
                         pressureList.add(pressureFlows.get(s));
                     }else if (pressureFlows.get(s).getDeviceType()=="2"){
                         flowmeterList.add(pressureFlows.get(s));
                     }else if (pressureFlows.get(s).getDeviceType()=="3"){
                         detectorList.add(pressureFlows.get(s));
                     }
                 }
            }
            //压力表设备数量添加
            tSiteStationInfoData.get(i).setNumberPressureGauges(pressureList.size());
            tSiteStationInfoData.get(i).setPressureFlows(List);
            //流量计设备数量添加
            tSiteStationInfoData.get(i).setNumberEquipment(flowmeterList.size());
            //探测器设备数量添加
            tSiteStationInfoData.get(i).setDetectorEquipment(detectorList.size());
            tSiteStationInfoData.get(i).setIconType(4);
        }
        tSiteStationInfoDataList.setData(tSiteStationInfoData);
        return tSiteStationInfoDataList;
    }

    /**
     * 监控信息查询
     */
    @RequestBody
    @RequestMapping("/selectTvideoManagerData")
    public List<TvideoManagerData> selectTvideoManagerData(){
        //查询监控信息
        List<TvideoManagerData> tvideoManagerData = iPipeInterfaceService.selectTvideoManagerData();
        for (int i=0;i<tvideoManagerData.size();i++){
            tvideoManagerData.get(i).setIconType(5);
            if("999".equals(tvideoManagerData.get(i).getCompanyType())){
                tvideoManagerData.get(i).setCompanyType(null);
            }else if("0".equals(tvideoManagerData.get(i).getCompanyType())){
                tvideoManagerData.get(i).setCompanyType(null);
            }
        }
        return tvideoManagerData;
    }

    /**
     * 燃气用户信息查询接口
     */
    @RequestBody
    @RequestMapping("/selectTdetectorUser")
    public TenterpriseInfoDataList selectTdetectorUser(){
        TenterpriseInfoDataList tenterpriseInfoDataList=new TenterpriseInfoDataList();
       //燃气用户信息查询方法
        List<TdetectorUserData> tdetectorUserData = iPipeInterfaceService.selectTdetectorUser();
        for (int i=0;i<tdetectorUserData.size();i++){
            tdetectorUserData.get(i).setIconType(6);
        }
        tenterpriseInfoDataList.setData(tdetectorUserData);
        return tenterpriseInfoDataList;
    }

    /**
     * 企业名称id查询接口
     */
    @RequestBody
    @RequestMapping("/selectTenterpriseInfoData")
    public List<TenterpriseInfoData> selectTenterpriseInfoData(){
        //查询企业名称id方法
        List<TenterpriseInfoData> tenterpriseInfoData = iPipeInterfaceService.selectTenterpriseInfoData();
        return tenterpriseInfoData;
    }


    /**
     * 阀门数据查询接口   使用中
     * @return
     */
    @RequestBody
    @RequestMapping("/selectvalveData")
    public DeviceDataList selectvalveData(){
        //最后返回的封装类型
        DeviceDataList deviceDataList=new DeviceDataList();
        List<DeviceData> list =new ArrayList<>();

        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //查询阀门井数据
        List<DeviceData> pipeDates = iPipeInterfaceService.selectvalveData(user.getDeptId());
//        //查询下级全部数据方法
//        List<PressureFlow> pressureFlows1 = iPipeInterfaceService.selectPressureFlows("1");
//        for (int i=0;i<pipeDates.size();i++){
//            boolean bo=false;
//            for (int s=0;s<pressureFlows1.size();s++){
//                if (pressureFlows1.get(s).getDeviceId().equals(pipeDates.get(i).getDeviceId())){
//                    bo=true;
//                    break;
//                }
//            }
//            if (bo){
//                pipeDates.get(i).setIconType(3);
//                list.add(pipeDates.get(i));
//            }
//        }
        for (int i=0;i<pipeDates.size();i++){
            pipeDates.get(i).setIconType(3);
            list.add(pipeDates.get(i));
        }
        deviceDataList.setData(list);
        return deviceDataList;
    }



    /**
     * 阀门数据查询接口
     */
    @RequestBody
    @RequestMapping("/selectvalveDatas")
    public DeviceDataList selectvalveDatas(){
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
            user.setDeptId("0");
        }
        //查询阀门井数据
        List<DeviceData> pipeDates = iPipeInterfaceService.selectvalveData(String.valueOf(user.getDeptId()));
        //查询下级数据
        List<PressureFlow> pressureFlows1 = iPipeInterfaceService.selectPressureFlow("1");
        //最后返回的封装类型
        DeviceDataList deviceDataList=new DeviceDataList();
        //调压箱数据循环
        for (int i=0;i<pipeDates.size();i++){
            //临时存储压力表数据数组
            List<PressureFlow> pressureList=new ArrayList<>();
            //临时存储流量计数据数组
            List<PressureFlow> flowmeterList=new ArrayList<>();
            //临时存储探测器数据数组
            List<PressureFlow> detectorList=new ArrayList();
            //存储全部数据
            List<PressureFlow> List=new ArrayList<>();
            for (int s=0;s<pressureFlows1.size();s++){
                //判断调压箱id与下级数据调压箱id是否相等
                if (pressureFlows1.get(s).getDeviceId()==pipeDates.get(i).getDeviceId()){
                    List.add(pressureFlows1.get(s));
                    //判断是压力表还是流量计   1压力表  2流量计
                    if (pressureFlows1.get(s).getDeviceType()=="1"){
                        pressureList.add(pressureFlows1.get(s));
                    }else if(pressureFlows1.get(s).getDeviceType()=="2"){
                        flowmeterList.add(pressureFlows1.get(s));
                    }else if(pressureFlows1.get(s).getDeviceType()=="3"){
                        detectorList.add(pressureFlows1.get(s));
                    }
                }
            }
            //压力表设备数量添加
            pipeDates.get(i).setNumberPressureGauges(pressureList.size());
            pipeDates.get(i).setPressureFlows(List);
            //流量计设备数量添加
            pipeDates.get(i).setNumberEquipment(flowmeterList.size());
            //探测器设备数量添加
            pipeDates.get(i).setDetectorEquipment(detectorList.size());
            pipeDates.get(i).setIconType(3);
        }
            deviceDataList.setData(pipeDates);
        return deviceDataList;
    }


    /**
     * 首页 场站/设备 感知设备信息列表查询接口
     * @param devId
     * @param relationDeviceType
     * @return
     */
    @RequestBody
    @RequestMapping("/selectSensingDevice")
    public List<TAssociatedEquipment> selectSensingDevice(@Param("devId") String devId,@Param("relationDeviceType") String relationDeviceType){
        startPage();
        //查询 场站/设备 列表信息方法
        List<TAssociatedEquipment> tAssociatedEquipments = iPipeInterfaceService.selectSensingDevice(devId, relationDeviceType);
        return tAssociatedEquipments;
    }

}
