package com.zehong.web.controller.standingBook;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.form.THiddenDangerStandingBookForm;
import com.zehong.web.controller.tool.TimeConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.service.ITHiddenDangerStandingBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患整治台账Controller
 *
 * @author zehong
 * @date 2022-02-09
 */
@RestController
@RequestMapping("/standingBook/hidden")
public class THiddenDangerStandingBookController extends BaseController
{
    @Autowired
    private ITHiddenDangerStandingBookService tHiddenDangerStandingBookService;

    /**
     * 查询隐患整治台账列表
     */
    @GetMapping("/list")
    public TableDataInfo list(THiddenDangerStandingBookForm tHiddenDangerStandingBook)
    {
        startPage();
        List<THiddenDangerStandingBook> list = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);
        return getDataTable(list);
    }
    /**
     * 统计每个月隐患数量
     * @return
     */
    @GetMapping("/selectCountByMonth")
    public AjaxResult selectCountByMonth(){
        List<Map<String,Object>> list = tHiddenDangerStandingBookService.selectCountByMonth();
        return AjaxResult.success(list);
    }
    /**
     * 统计每年隐患数量
     * @return
     */
    @GetMapping("/selectCountByYear")
    public AjaxResult selectCountByYear(){
        List<Map<String,Object>> list = tHiddenDangerStandingBookService.selectCountByYear();
        return AjaxResult.success(list);
    }
    /**
     * 根据乡镇统计隐患数量
     * @return
     */
    @GetMapping("/selectHiddenRanking")
    public AjaxResult selectHiddenRanking(){
        List<Map<String,Object>> list = tHiddenDangerStandingBookService.selectHiddenRanking();
        return AjaxResult.success(list);
    }
    /**
     * 根据隐患来源统计隐患数量
     * @return
     */
    @GetMapping("/selectHiddenSource")
    public AjaxResult selectHiddenSource(){
        List<Map<String,Object>> list = tHiddenDangerStandingBookService.selectHiddenSource();
        return AjaxResult.success(list);
    }


    /**
     * 获取隐患整治台账统计信息
     */
    @GetMapping("/hazardStatistics")
    public AjaxResult hazardStatistics()
    {
        //生成近7天数据
        List<String> sevenDate = TimeConfig.getSevenDate();
        List<Statistics> list=new ArrayList<>();
        //查询统计日期和数量
        List<Statistics> statistics = tHiddenDangerStandingBookService.hazardStatistics(TimeConfig.getSevenDate());
        if (statistics.size()==0){
            for (int n=0;n<7;n++){
                Statistics statisticsn=new Statistics();
                statisticsn.setCount(0);
                statisticsn.setDate(sevenDate.get(n));
                list.add(statisticsn);
            }
        }

        for (int i=0;i<sevenDate.size();i++){
            Statistics statistics1=new Statistics();
            boolean isExist = false;
            for (int s=0;s<statistics.size();s++){
                if (statistics.get(s).getDate().equals(sevenDate.get(i))){
                    statistics1.setCount(statistics.get(s).getCount());
                    statistics1.setDate(sevenDate.get(i));
                    list.add(statistics1);
                    isExist = true;
                }
            }
            if(!isExist){
                statistics1.setCount(0);
                statistics1.setDate(sevenDate.get(i));
                list.add(statistics1);
            }
        }
        return AjaxResult.success(list);
    }

    /**
     * 导出隐患整治台账列表
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenDangerStandingBookForm tHiddenDangerStandingBook)
    {
        List<THiddenDangerStandingBook> list = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);
        ExcelUtil<THiddenDangerStandingBook> util = new ExcelUtil<THiddenDangerStandingBook>(THiddenDangerStandingBook.class);
        return util.exportExcel(list, "隐患整治台账数据");
    }

    /**
     * 获取隐患整治台账详细信息
     */
    @GetMapping(value = "/{hiddenId}")
    public AjaxResult getInfo(@PathVariable("hiddenId") Long hiddenId)
    {
        return AjaxResult.success(tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookById(hiddenId));
    }

    /**
     * 新增隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        return toAjax(tHiddenDangerStandingBookService.insertTHiddenDangerStandingBook(tHiddenDangerStandingBook));
    }

    /**
     * 修改隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        return toAjax(tHiddenDangerStandingBookService.updateTHiddenDangerStandingBook(tHiddenDangerStandingBook));
    }

    /**
     * 删除隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{hiddenIds}")
    public AjaxResult remove(@PathVariable Long[] hiddenIds)
    {
        return toAjax(tHiddenDangerStandingBookService.deleteTHiddenDangerStandingBookByIds(hiddenIds));
    }

    /**
     * 隐患统计
     * @return
     */
    @GetMapping("/hiddenBookStatistics")
    public AjaxResult hiddenBookStatistics(){
        return AjaxResult.success(tHiddenDangerStandingBookService.hiddenBookStatistics());
    }
}
