package com.zehong.web.controller.operationMonitor;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupervisorInfo;
import com.zehong.system.service.ITSupervisorInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气督办Controller
 * 
 * @author zehong
 * @date 2022-03-31
 */
@RestController
@RequestMapping("/supervisor/info")
public class TSupervisorInfoController extends BaseController
{
    @Autowired
    private ITSupervisorInfoService tSupervisorInfoService;

    /**
     * 查询燃气督办列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupervisorInfo tSupervisorInfo)
    {
        startPage();
        List<TSupervisorInfo> list = tSupervisorInfoService.selectTSupervisorInfoList(tSupervisorInfo);
        return getDataTable(list);
    }

    /**
     * 查询燃气督办list
     * @param tSupervisorInfo
     * @return
     */
    @GetMapping("/supervisorInfoList")
    public AjaxResult supervisorInfoList(TSupervisorInfo tSupervisorInfo)
    {
        return AjaxResult.success( tSupervisorInfoService.selectTSupervisorInfoList(tSupervisorInfo));
    }

    /**
     * 导出燃气督办列表
     */
    @Log(title = "燃气督办", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupervisorInfo tSupervisorInfo)
    {
        List<TSupervisorInfo> list = tSupervisorInfoService.selectTSupervisorInfoList(tSupervisorInfo);
        ExcelUtil<TSupervisorInfo> util = new ExcelUtil<TSupervisorInfo>(TSupervisorInfo.class);
        return util.exportExcel(list, "燃气督办数据");
    }

    /**
     * 获取燃气督办详细信息
     */
    @GetMapping(value = "/{supervisorId}")
    public AjaxResult getInfo(@PathVariable("supervisorId") Long supervisorId)
    {
        return AjaxResult.success(tSupervisorInfoService.selectTSupervisorInfoById(supervisorId));
    }

    /**
     * 新增燃气督办
     */
    @Log(title = "燃气督办", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupervisorInfo tSupervisorInfo)
    {
        return toAjax(tSupervisorInfoService.insertTSupervisorInfo(tSupervisorInfo));
    }

    /**
     * 修改燃气督办
     */
    @Log(title = "燃气督办", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupervisorInfo tSupervisorInfo)
    {
        return toAjax(tSupervisorInfoService.updateTSupervisorInfo(tSupervisorInfo));
    }

    /**
     * 删除燃气督办
     */
    @Log(title = "燃气督办", businessType = BusinessType.DELETE)
	@DeleteMapping("/{supervisorIds}")
    public AjaxResult remove(@PathVariable Long[] supervisorIds)
    {
        return toAjax(tSupervisorInfoService.deleteTSupervisorInfoByIds(supervisorIds));
    }
}
