package com.zehong.web.controller.operationMonitor;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenTroubleInfo;
import com.zehong.system.service.ITHiddenTroubleInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气隐患Controller
 * 
 * @author zehong
 * @date 2022-03-24
 */
@RestController
@RequestMapping("/system/hidden")
public class THiddenTroubleInfoController extends BaseController
{
    @Autowired
    private ITHiddenTroubleInfoService tHiddenTroubleInfoService;

    /**
     * 查询燃气隐患列表
     */
    @GetMapping("/list")
    public TableDataInfo list(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        startPage();
        List<THiddenTroubleInfo> list = tHiddenTroubleInfoService.selectTHiddenTroubleInfoList(tHiddenTroubleInfo);
        return getDataTable(list);
    }

    @GetMapping("/hiddenTroubleList")
    public AjaxResult hiddenTroubleList(THiddenTroubleInfo tHiddenTroubleInfo){
        return AjaxResult.success(tHiddenTroubleInfoService.selectTHiddenTroubleInfoList(tHiddenTroubleInfo));
    }

    /**
     * 导出燃气隐患列表
     */
    @Log(title = "燃气隐患", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        List<THiddenTroubleInfo> list = tHiddenTroubleInfoService.selectTHiddenTroubleInfoList(tHiddenTroubleInfo);
        ExcelUtil<THiddenTroubleInfo> util = new ExcelUtil<THiddenTroubleInfo>(THiddenTroubleInfo.class);
        return util.exportExcel(list, "燃气隐患数据");
    }

    /**
     * 获取燃气隐患详细信息
     */
    @GetMapping(value = "/{hiddenTroubleId}")
    public AjaxResult getInfo(@PathVariable("hiddenTroubleId") Long hiddenTroubleId)
    {
        return AjaxResult.success(tHiddenTroubleInfoService.selectTHiddenTroubleInfoById(hiddenTroubleId));
    }

    /**
     * 新增燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenTroubleInfo tHiddenTroubleInfo)
    {
        return toAjax(tHiddenTroubleInfoService.insertTHiddenTroubleInfo(tHiddenTroubleInfo));
    }

    /**
     * 修改燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenTroubleInfo tHiddenTroubleInfo)
    {
        return toAjax(tHiddenTroubleInfoService.updateTHiddenTroubleInfo(tHiddenTroubleInfo));
    }

    /**
     * 删除燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.DELETE)
	@DeleteMapping("/{hiddenTroubleIds}")
    public AjaxResult remove(@PathVariable Long[] hiddenTroubleIds)
    {
        return toAjax(tHiddenTroubleInfoService.deleteTHiddenTroubleInfoByIds(hiddenTroubleIds));
    }
}
