package com.zehong.web.controller.operationMonitor;

import java.util.List;

import com.zehong.system.domain.form.TDetectorReportDataQueryForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDetectorReportData;
import com.zehong.system.service.ITDetectorReportDataService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气用户设备上报的数据Controller
 * 
 * @author zehong
 * @date 2022-03-04
 */
@RestController
@RequestMapping("/detector/detectorReportData")
public class TDetectorReportDataController extends BaseController
{
    @Autowired
    private ITDetectorReportDataService tDetectorReportDataService;

    /**
     * 查询燃气用户设备上报的数据列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDetectorReportDataQueryForm tDetectorReportDataQueryForm)
    {
        startPage();
        List<TDetectorReportData> list = tDetectorReportDataService.selectTDetectorReportDataList(tDetectorReportDataQueryForm);
        return getDataTable(list);
    }

    /**
     * 导出燃气用户设备上报的数据列表
     */
    @Log(title = "燃气用户设备上报的数据", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDetectorReportDataQueryForm tDetectorReportDataQueryForm)
    {
        List<TDetectorReportData> list = tDetectorReportDataService.selectTDetectorReportDataList(tDetectorReportDataQueryForm);
        ExcelUtil<TDetectorReportData> util = new ExcelUtil<TDetectorReportData>(TDetectorReportData.class);
        return util.exportExcel(list, "燃气用户设备上报的数据数据");
    }

    /**
     * 获取燃气用户设备上报的数据详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDetectorReportDataService.selectTDetectorReportDataById(id));
    }

    /**
     * 新增燃气用户设备上报的数据
     */
    @Log(title = "燃气用户设备上报的数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDetectorReportData tDetectorReportData)
    {
        return toAjax(tDetectorReportDataService.insertTDetectorReportData(tDetectorReportData));
    }

    /**
     * 修改燃气用户设备上报的数据
     */
    @Log(title = "燃气用户设备上报的数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDetectorReportData tDetectorReportData)
    {
        return toAjax(tDetectorReportDataService.updateTDetectorReportData(tDetectorReportData));
    }

    /**
     * 删除燃气用户设备上报的数据
     */
    @Log(title = "燃气用户设备上报的数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDetectorReportDataService.deleteTDetectorReportDataByIds(ids));
    }
}
