package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.BottleStatistics;
import com.zehong.system.domain.TGasBottleInfo;
import com.zehong.system.service.ITGasBottleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 气瓶信息Controller
 *
 * @author zehong
 * @date 2023-08-15
 */
@RestController
@RequestMapping("/gasBottle/info")
public class TGasBottleInfoController extends BaseController
{
    @Autowired
    private ITGasBottleInfoService tGasBottleInfoService;

    /**
     * 查询气瓶信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TGasBottleInfo tGasBottleInfo)
    {
        startPage();
        List<TGasBottleInfo> list = tGasBottleInfoService.selectTGasBottleInfoList(tGasBottleInfo);
        return getDataTable(list);
    }

    @GetMapping("/bottleInfoList")
    public AjaxResult bottleInfoList(TGasBottleInfo tGasBottleInfo)
    {
        List<TGasBottleInfo> list = tGasBottleInfoService.selectTGasBottleInfoList(tGasBottleInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出气瓶信息列表
     */
    @Log(title = "气瓶信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasBottleInfo tGasBottleInfo)
    {
        List<TGasBottleInfo> list = tGasBottleInfoService.selectTGasBottleInfoList(tGasBottleInfo);
        ExcelUtil<TGasBottleInfo> util = new ExcelUtil<TGasBottleInfo>(TGasBottleInfo.class);
        return util.exportExcel(list, "气瓶信息数据");
    }

    /**
     * 获取气瓶信息详细信息
     */
    @GetMapping(value = "/{bottleId}")
    public AjaxResult getInfo(@PathVariable("bottleId") Long bottleId)
    {
        return AjaxResult.success(tGasBottleInfoService.selectTGasBottleInfoById(bottleId));
    }

    @GetMapping("/getInf")
    public AjaxResult getInf(String bottleId)
    {
        /**
         * 查询气瓶详细信息
         */
        TGasBottleInfo inf = tGasBottleInfoService.getInf(bottleId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasBottleInfo", inf);
        return ajax;
    }


    @GetMapping("/getInfn")
    public AjaxResult getInfn(String bottleId)
    {
        /**
         * 查询气瓶详细信息
         */
        TGasBottleInfo inf = tGasBottleInfoService.getInfn(bottleId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasBottleInfo", inf);
        return ajax;
    }

    /**
     * 新增气瓶信息
     */
    @Log(title = "气瓶信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasBottleInfo tGasBottleInfo)
    {
        TGasBottleInfo tGasBottleInfo1=new TGasBottleInfo();
        tGasBottleInfo1.setBottleCode(tGasBottleInfo.getBottleCode());
        /**
         * 查询气瓶详细信息
         */
        List<TGasBottleInfo> list = tGasBottleInfoService.selectTGasBottleInfoList(tGasBottleInfo1);
        if (list.size()>=1){
            return null;
        }
        return toAjax(tGasBottleInfoService.insertTGasBottleInfo(tGasBottleInfo));
    }

    /**
     * 修改气瓶信息
     */
    @Log(title = "气瓶信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasBottleInfo tGasBottleInfo)
    {
        return toAjax(tGasBottleInfoService.updateTGasBottleInfo(tGasBottleInfo));
    }

    /**
     * 删除气瓶信息
     */
    @Log(title = "气瓶信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bottleIds}")
    public AjaxResult remove(@PathVariable Long[] bottleIds)
    {
        return toAjax(tGasBottleInfoService.deleteTGasBottleInfoByIds(bottleIds));
    }

    /**
     * 气瓶导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @Log(title = "气瓶导入", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TGasBottleInfo> util = new ExcelUtil<>(TGasBottleInfo.class);
        List<TGasBottleInfo> tGasBottleInfoList = util.importExcel(file.getInputStream());
        String message = tGasBottleInfoService.importTGasBottleInfo(tGasBottleInfoList, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TGasBottleInfo> util = new ExcelUtil<>(TGasBottleInfo.class);
        return util.importTemplateExcel("气瓶数据");
    }

    @GetMapping("/bottleStatistics")
    public TableDataInfo bottleStatistics(@RequestParam(value="stationId",required = false) Long stationId){
        startPage();
        return getDataTable(tGasBottleInfoService.bottleStatistics(stationId));
    }

    @GetMapping("/bottleStatisticsExport")
    public AjaxResult bottleStatisticsExport(@RequestParam(value = "stationId",required = false) Long stationId)
    {
        List<BottleStatistics> statistics = tGasBottleInfoService.bottleStatistics(stationId);
        ExcelUtil<BottleStatistics> util = new ExcelUtil<>(BottleStatistics.class);
        return util.exportExcel(statistics, "气瓶信息数据");
    }
}
