package com.zehong.web.controller.complainDeal;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TComplainDealManSysSet;
import com.zehong.system.service.ITComplainDealManSysSetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 燃气投诉处置的管理制度维护Controller
 * 
 * @author zehong
 * @date 2024-06-05
 */
@RestController
@RequestMapping("/complainDeal/set")
public class TComplainDealManSysSetController extends BaseController
{
    @Autowired
    private ITComplainDealManSysSetService tComplainDealManSysSetService;

    /**
     * 查询燃气投诉处置的管理制度维护列表
     */
    @GetMapping("/list")
    public AjaxResult list(TComplainDealManSysSet tComplainDealManSysSet)
    {
        List<TComplainDealManSysSet> list = tComplainDealManSysSetService.selectTComplainDealManSysSetList(tComplainDealManSysSet);
        return AjaxResult.success(list);
    }


    /**
     * 查询燃气投诉处置的管理制度维护列表
     */
    @PostMapping("/batchUpdate")
    public AjaxResult batchUpdate(@RequestBody List<TComplainDealManSysSet> tComplainDealManSysSets)
    {
        tComplainDealManSysSetService.batchUpdate(tComplainDealManSysSets);
        return AjaxResult.success(tComplainDealManSysSets);
    }

    /**
     * 导出燃气投诉处置的管理制度维护列表
     */
    @Log(title = "燃气投诉处置的管理制度维护", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TComplainDealManSysSet tComplainDealManSysSet)
    {
        List<TComplainDealManSysSet> list = tComplainDealManSysSetService.selectTComplainDealManSysSetList(tComplainDealManSysSet);
        ExcelUtil<TComplainDealManSysSet> util = new ExcelUtil<TComplainDealManSysSet>(TComplainDealManSysSet.class);
        return util.exportExcel(list, "燃气投诉处置的管理制度维护数据");
    }

    /**
     * 获取燃气投诉处置的管理制度维护详细信息
     */
    @GetMapping(value = "/{fComplainDealManSysSetId}")
    public AjaxResult getInfo(@PathVariable("fComplainDealManSysSetId") Long fComplainDealManSysSetId)
    {
        return AjaxResult.success(tComplainDealManSysSetService.selectTComplainDealManSysSetById(fComplainDealManSysSetId));
    }

    /**
     * 新增燃气投诉处置的管理制度维护
     */
    @Log(title = "燃气投诉处置的管理制度维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TComplainDealManSysSet tComplainDealManSysSet)
    {
        return toAjax(tComplainDealManSysSetService.insertTComplainDealManSysSet(tComplainDealManSysSet));
    }

    /**
     * 修改燃气投诉处置的管理制度维护
     */
    @Log(title = "燃气投诉处置的管理制度维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TComplainDealManSysSet tComplainDealManSysSet)
    {
        return toAjax(tComplainDealManSysSetService.updateTComplainDealManSysSet(tComplainDealManSysSet));
    }

    /**
     * 删除燃气投诉处置的管理制度维护
     */
    @Log(title = "燃气投诉处置的管理制度维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fComplainDealManSysSetIds}")
    public AjaxResult remove(@PathVariable Long[] fComplainDealManSysSetIds)
    {
        return toAjax(tComplainDealManSysSetService.deleteTComplainDealManSysSetByIds(fComplainDealManSysSetIds));
    }
}
