package com.zehong.web.controller.complainDeal;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TComplainDealEvaluate;
import com.zehong.system.service.ITComplainDealEvaluateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 燃气投诉处置-评价Controller
 * 
 * @author zehong
 * @date 2024-06-06
 */
@RestController
@RequestMapping("/complainDeal/evaluate")
public class TComplainDealEvaluateController extends BaseController
{
    @Autowired
    private ITComplainDealEvaluateService tComplainDealEvaluateService;

    /**
     * 查询燃气投诉处置-评价列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TComplainDealEvaluate tComplainDealEvaluate)
    {
        startPage();
        List<TComplainDealEvaluate> list = tComplainDealEvaluateService.selectTComplainDealEvaluateList(tComplainDealEvaluate);
        return getDataTable(list);
    }

    /**
     * 导出燃气投诉处置-评价列表
     */
    @Log(title = "燃气投诉处置-评价", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TComplainDealEvaluate tComplainDealEvaluate)
    {
        List<TComplainDealEvaluate> list = tComplainDealEvaluateService.selectTComplainDealEvaluateList(tComplainDealEvaluate);
        ExcelUtil<TComplainDealEvaluate> util = new ExcelUtil<TComplainDealEvaluate>(TComplainDealEvaluate.class);
        return util.exportExcel(list, "燃气投诉处置-评价数据");
    }

    /**
     * 获取燃气投诉处置-评价详细信息
     */
    @GetMapping(value = "/{complainDealEvaluateId}")
    public AjaxResult getInfo(@PathVariable("complainDealEvaluateId") Long complainDealEvaluateId)
    {
        return AjaxResult.success(tComplainDealEvaluateService.selectTComplainDealEvaluateById(complainDealEvaluateId));
    }

    /**
     * 获取燃气投诉处置-评价详细信息
     */
    @GetMapping(value = "/getByComplainDealId/{complainDealId}")
    public AjaxResult getByComplainDealId(@PathVariable("complainDealId") Long complainDealId)
    {
        return AjaxResult.success(tComplainDealEvaluateService.selectTComplainDealEvaluateByComplainDealId(complainDealId));
    }

    /**
     * 新增燃气投诉处置-评价
     */
    @Log(title = "燃气投诉处置-评价", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TComplainDealEvaluate tComplainDealEvaluate)
    {
        return toAjax(tComplainDealEvaluateService.insertTComplainDealEvaluate(tComplainDealEvaluate));
    }

    /**
     * 修改燃气投诉处置-评价
     */
    @Log(title = "燃气投诉处置-评价", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TComplainDealEvaluate tComplainDealEvaluate)
    {
        return toAjax(tComplainDealEvaluateService.updateTComplainDealEvaluate(tComplainDealEvaluate));
    }

    /**
     * 删除燃气投诉处置-评价
     */
    @Log(title = "燃气投诉处置-评价", businessType = BusinessType.DELETE)
	@DeleteMapping("/{complainDealEvaluateIds}")
    public AjaxResult remove(@PathVariable Long[] complainDealEvaluateIds)
    {
        return toAjax(tComplainDealEvaluateService.deleteTComplainDealEvaluateByIds(complainDealEvaluateIds));
    }
}
