package com.zehong.web.controller.area;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TVillageLevelRegion;
import com.zehong.system.service.ITVillageLevelRegionService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 村级行政区Controller
 * 
 * @author zehong
 * @date 2024-06-07
 */
@RestController
@RequestMapping("/area/village")
public class TVillageLevelRegionController extends BaseController
{
    @Autowired
    private ITVillageLevelRegionService tVillageLevelRegionService;

    /**
     * 查询村级行政区列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TVillageLevelRegion tVillageLevelRegion)
    {
        startPage();
        List<TVillageLevelRegion> list = tVillageLevelRegionService.selectTVillageLevelRegionList(tVillageLevelRegion);
        return getDataTable(list);
    }

    /**
     * 导出村级行政区列表
     */
    @Log(title = "村级行政区", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVillageLevelRegion tVillageLevelRegion)
    {
        List<TVillageLevelRegion> list = tVillageLevelRegionService.selectTVillageLevelRegionList(tVillageLevelRegion);
        ExcelUtil<TVillageLevelRegion> util = new ExcelUtil<TVillageLevelRegion>(TVillageLevelRegion.class);
        return util.exportExcel(list, "村级行政区数据");
    }

    /**
     * 获取村级行政区详细信息
     */
    @GetMapping(value = "/{fId}")
    public AjaxResult getInfo(@PathVariable("fId") Long fId)
    {
        return AjaxResult.success(tVillageLevelRegionService.selectTVillageLevelRegionById(fId));
    }

    /**
     * 新增村级行政区
     */
    @Log(title = "村级行政区", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVillageLevelRegion tVillageLevelRegion)
    {
        return toAjax(tVillageLevelRegionService.insertTVillageLevelRegion(tVillageLevelRegion));
    }

    /**
     * 修改村级行政区
     */
    @Log(title = "村级行政区", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVillageLevelRegion tVillageLevelRegion)
    {
        return toAjax(tVillageLevelRegionService.updateTVillageLevelRegion(tVillageLevelRegion));
    }

    /**
     * 删除村级行政区
     */
    @Log(title = "村级行政区", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fIds}")
    public AjaxResult remove(@PathVariable Long[] fIds)
    {
        return toAjax(tVillageLevelRegionService.deleteTVillageLevelRegionByIds(fIds));
    }
}
