package com.zehong.web.controller.area;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTownLevelRegion;
import com.zehong.system.service.ITTownLevelRegionService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 乡级行政区Controller
 * 
 * @author zehong
 * @date 2024-06-07
 */
@RestController
@RequestMapping("/area/town")
public class TTownLevelRegionController extends BaseController
{
    @Autowired
    private ITTownLevelRegionService tTownLevelRegionService;

    /**
     * 查询乡级行政区列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTownLevelRegion tTownLevelRegion)
    {
        startPage();
        List<TTownLevelRegion> list = tTownLevelRegionService.selectTTownLevelRegionList(tTownLevelRegion);
        return getDataTable(list);
    }

    /**
     * 导出乡级行政区列表
     */
    @Log(title = "乡级行政区", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTownLevelRegion tTownLevelRegion)
    {
        List<TTownLevelRegion> list = tTownLevelRegionService.selectTTownLevelRegionList(tTownLevelRegion);
        ExcelUtil<TTownLevelRegion> util = new ExcelUtil<TTownLevelRegion>(TTownLevelRegion.class);
        return util.exportExcel(list, "乡级行政区数据");
    }

    /**
     * 获取乡级行政区详细信息
     */
    @GetMapping(value = "/{fId}")
    public AjaxResult getInfo(@PathVariable("fId") Long fId)
    {
        return AjaxResult.success(tTownLevelRegionService.selectTTownLevelRegionById(fId));
    }

    /**
     * 新增乡级行政区
     */
    @Log(title = "乡级行政区", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTownLevelRegion tTownLevelRegion)
    {
        return toAjax(tTownLevelRegionService.insertTTownLevelRegion(tTownLevelRegion));
    }

    /**
     * 修改乡级行政区
     */
    @Log(title = "乡级行政区", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTownLevelRegion tTownLevelRegion)
    {
        return toAjax(tTownLevelRegionService.updateTTownLevelRegion(tTownLevelRegion));
    }

    /**
     * 删除乡级行政区
     */
    @Log(title = "乡级行政区", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fIds}")
    public AjaxResult remove(@PathVariable Long[] fIds)
    {
        return toAjax(tTownLevelRegionService.deleteTTownLevelRegionByIds(fIds));
    }
}
