package com.zehong.web.controller.area;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TCityLevelRegion;
import com.zehong.system.service.ITCityLevelRegionService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 市级行政区Controller
 * 
 * @author zehong
 * @date 2024-06-06
 */
@RestController
@RequestMapping("/area/city")
public class TCityLevelRegionController extends BaseController
{
    @Autowired
    private ITCityLevelRegionService tCityLevelRegionService;

    /**
     * 查询市级行政区列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TCityLevelRegion tCityLevelRegion)
    {
        startPage();
        List<TCityLevelRegion> list = tCityLevelRegionService.selectTCityLevelRegionList(tCityLevelRegion);
        return getDataTable(list);
    }

    /**
     * 导出市级行政区列表
     */
    @Log(title = "市级行政区", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TCityLevelRegion tCityLevelRegion)
    {
        List<TCityLevelRegion> list = tCityLevelRegionService.selectTCityLevelRegionList(tCityLevelRegion);
        ExcelUtil<TCityLevelRegion> util = new ExcelUtil<TCityLevelRegion>(TCityLevelRegion.class);
        return util.exportExcel(list, "市级行政区数据");
    }

    /**
     * 获取市级行政区详细信息
     */
    @GetMapping(value = "/{fId}")
    public AjaxResult getInfo(@PathVariable("fId") Long fId)
    {
        return AjaxResult.success(tCityLevelRegionService.selectTCityLevelRegionById(fId));
    }

    /**
     * 新增市级行政区
     */
    @Log(title = "市级行政区", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TCityLevelRegion tCityLevelRegion)
    {
        return toAjax(tCityLevelRegionService.insertTCityLevelRegion(tCityLevelRegion));
    }

    /**
     * 修改市级行政区
     */
    @Log(title = "市级行政区", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TCityLevelRegion tCityLevelRegion)
    {
        return toAjax(tCityLevelRegionService.updateTCityLevelRegion(tCityLevelRegion));
    }

    /**
     * 删除市级行政区
     */
    @Log(title = "市级行政区", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fIds}")
    public AjaxResult remove(@PathVariable Long[] fIds)
    {
        return toAjax(tCityLevelRegionService.deleteTCityLevelRegionByIds(fIds));
    }
}
