package com.zehong.web.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/token")
public class TokenController {

    @Autowired
    private OutUtil outUtil;

    /**
     * 获取营业执照
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/getInfo")
    public AjaxResult getInfo()throws Exception
    {
        Map<String,Object> map = new HashMap<>();
        map.put("updateTime","2022-11-28 14:01:00");
        map.put("pageSize",100);
        map.put("pageIndex",1);
        map.put("cityId",10000010);
        String domain = "region/county/information";
        JSONObject json = outUtil.getInfo(domain,"READ",map);
        return AjaxResult.success(json);
    }

    /**
     * 通用获取省厅平台接口
     * @param map 请求参数  接口的  condition 条件下的参数
     *            例：
     *             map.put("updateTime","2022-11-28 14:01:00");
     *             map.put("pageSize",100);
     *             map.put("pageIndex",1);
     * @param domain
     *          例：界面文档下面的 domain
     *            professor/application/information
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/currencyGetInfo")
    public AjaxResult currencyGetInfo(Map<String,Object> map ,String domain)throws Exception
    {
        JSONObject json = outUtil.getInfo(domain,"READ",map);
        return AjaxResult.success(json);
    }

    /**
     *
     * @param list  list 里面 封装 map
     *            例：
     * [{"id": "13",
     *   "idNo": "321323198802176876",
     *   "expertEval": "很好",
     *   "selectionEvent": "安全检查",
     *   "selectionStartTime": "2024-01-06",
     *   "scorDesc": "说明很好",
     *   "updateTime": "2024-01-06" }
     *  ]
     * @param domain
     *         例：界面文档下面的 domain
     *         professor/application/information
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/currencySetInfo")
    public AjaxResult currencySetInfo(List list ,String domain)throws Exception
    {
        JSONObject json = outUtil.setInfo(domain,"WRITE",list);
        return AjaxResult.success(json);
    }

    @GetMapping(value = "/setInfo")
    public AjaxResult setInfo()throws Exception
    {
        Map<String,Object> map = new HashMap<>();
        map.put("id","111");
        map.put("idNo","321323198802116876");
        map.put("expertEval","的好的");
        map.put("selectionEvent","没问题的");
        map.put("selectionStartTime","2024-04-05");
        map.put("scorDesc","巴适哦");
        map.put("updateTime","2024-04-05");
        List<Map<String,Object>> list = new ArrayList<>();
        list.add(map);
        String domain = "professor/application/information";
        JSONObject json = outUtil.setInfo(domain,"WRITE",list);
        return AjaxResult.success(json);
    }




}
