import request from '@/utils/request'

// 查询供需平衡-气量监管列表
export function listSup(query) {
  return request({
    url: '/supplyBalance/gas/list',
    method: 'get',
    params: query
  })
}

// 查询供需平衡-气量监管详细
export function getSup(fGasSupId) {
  return request({
    url: '/supplyBalance/gas/' + fGasSupId,
    method: 'get'
  })
}

// 新增供需平衡-气量监管
export function addSup(data) {
  return request({
    url: '/supplyBalance/gas',
    method: 'post',
    data: data
  })
}

// 修改供需平衡-气量监管
export function updateSup(data) {
  return request({
    url: '/supplyBalance/gas',
    method: 'put',
    data: data
  })
}

// 删除供需平衡-气量监管
export function delSup(fGasSupId) {
  return request({
    url: '/supplyBalance/gas/' + fGasSupId,
    method: 'delete'
  })
}

// 导出供需平衡-气量监管
export function exportSup(query) {
  return request({
    url: '/supplyBalance/gas/export',
    method: 'get',
    params: query
  })
}

export function getReportInfoByCompany(query) {
  return request({
    url: '/supplyBalance/gas/getReportInfoByCompany',
    method: 'get',
    params: query
  })
}

export function reportInfoList(query) {
  return request({
    url: '/supplyBalance/gas/reportInfoList',
    method: 'get',
    params: query
  })
}

export function reportSupBalGasSupRecInfo(query) {
  return request({
    url: '/supplyBalance/gas/reportSupBalGasSupRecInfo',
    method: 'get',
    params: query
  })
}
