import request from '@/utils/request'

// 查询监督检查-检查任务列表
export function listInfor(query) {
  return request({
    url: '/supervision/task/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-检查任务详细
export function getInfor(fInsTaskInforId) {
  return request({
    url: '/supervision/task/' + fInsTaskInforId,
    method: 'get'
  })
}

// 新增监督检查-检查任务
export function addInfor(data) {
  return request({
    url: '/supervision/task',
    method: 'post',
    data: data
  })
}

// 修改监督检查-检查任务
export function updateInfor(data) {
  return request({
    url: '/supervision/task',
    method: 'put',
    data: data
  })
}

// 删除监督检查-检查任务
export function delInfor(fInsTaskInforId) {
  return request({
    url: '/supervision/task/' + fInsTaskInforId,
    method: 'delete'
  })
}

// 导出监督检查-检查任务
export function exportInfor(query) {
  return request({
    url: '/supervision/task/export',
    method: 'get',
    params: query
  })
}

//所有任务
export function taskList(query) {
  return request({
    url: '/supervision/task/taskList',
    method: 'get',
    params: query
  })
}
