import request from '@/utils/request'

// 查询监督检查-抽查隐患列表
export function listRef(query) {
  return request({
    url: '/supervision/spot/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-抽查隐患详细
export function getRef(fInsSpotHazardRefId) {
  return request({
    url: '/supervision/spot/' + fInsSpotHazardRefId,
    method: 'get'
  })
}

// 新增监督检查-抽查隐患
export function addRef(data) {
  return request({
    url: '/supervision/spot',
    method: 'post',
    data: data
  })
}

// 修改监督检查-抽查隐患
export function updateRef(data) {
  return request({
    url: '/supervision/spot',
    method: 'put',
    data: data
  })
}

// 监督检查-抽查隐患-处置
export function disposeOfInsSpotHazardRef(data) {
  return request({
    url: '/supervision/spot/disposeOfInsSpotHazardRef',
    method: 'put',
    data: data
  })
}

// 删除监督检查-抽查隐患
export function delRef(fInsSpotHazardRefId) {
  return request({
    url: '/supervision/spot/' + fInsSpotHazardRefId,
    method: 'delete'
  })
}

// 导出监督检查-抽查隐患
export function exportRef(query) {
  return request({
    url: '/supervision/spot/export',
    method: 'get',
    params: query
  })
}
