import request from '@/utils/request'

// 查询监督检查-监督检查发现隐患及整改，执法结果列表
export function listRef(query) {
  return request({
    url: '/supervision/rectification/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-监督检查发现隐患及整改，执法结果详细
export function getRef(fInsHazRefId) {
  return request({
    url: '/supervision/rectification/' + fInsHazRefId,
    method: 'get'
  })
}

// 新增监督检查-监督检查发现隐患及整改，执法结果
export function addRef(data) {
  return request({
    url: '/supervision/rectification',
    method: 'post',
    data: data
  })
}

// 修改监督检查-监督检查发现隐患及整改，执法结果
export function updateRef(data) {
  return request({
    url: '/supervision/rectification',
    method: 'put',
    data: data
  })
}

// 删除监督检查-监督检查发现隐患及整改，执法结果
export function delRef(fInsHazRefId) {
  return request({
    url: '/supervision/rectification/' + fInsHazRefId,
    method: 'delete'
  })
}

// 导出监督检查-监督检查发现隐患及整改，执法结果
export function exportRef(query) {
  return request({
    url: '/supervision/rectification/export',
    method: 'get',
    params: query
  })
}

//上传
export function reportHazRefInfo(query) {
  return request({
    url: '/supervision/rectification/reportHazRefInfo',
    method: 'get',
    params: query
  })
}

//上传隐患
export function reportHazRefInfoByCheckCode(query) {
  return request({
    url: '/supervision/rectification/reportHazRefInfoByCheckCode',
    method: 'get',
    params: query
  })
}
