import request from '@/utils/request'

// 查询监督检查-检查记录列表
export function listInfor(query) {
  return request({
    url: '/supervision/record/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-检查记录详细
export function getInfor(fInsRecInforId) {
  return request({
    url: '/supervision/record/' + fInsRecInforId,
    method: 'get'
  })
}

// 新增监督检查-检查记录
export function addInfor(data) {
  return request({
    url: '/supervision/record',
    method: 'post',
    data: data
  })
}

// 修改监督检查-检查记录
export function updateInfor(data) {
  return request({
    url: '/supervision/record',
    method: 'put',
    data: data
  })
}

// 删除监督检查-检查记录
export function delInfor(fInsRecInforId) {
  return request({
    url: '/supervision/record/' + fInsRecInforId,
    method: 'delete'
  })
}

// 导出监督检查-检查记录
export function exportInfor(query) {
  return request({
    url: '/supervision/record/export',
    method: 'get',
    params: query
  })
}

//所有检查记录
export function recordList(query) {
  return request({
    url: '/supervision/record/recordList',
    method: 'get',
    params: query
  })
}

//上传检查记录
export function reportRecInfo(query) {
  return request({
    url: '/supervision/record/reportRecInfo',
    method: 'get',
    params: query
  })
}
