import request from '@/utils/request'

// 查询监督检查-隐患分类分级标准列表
export function listInfor(query) {
  return request({
    url: '/supervision/hideType/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-隐患分类分级标准详细
export function getInfor(fInsStaInforId) {
  return request({
    url: '/supervision/hideType/' + fInsStaInforId,
    method: 'get'
  })
}

// 新增监督检查-隐患分类分级标准
export function addInfor(data) {
  return request({
    url: '/supervision/hideType',
    method: 'post',
    data: data
  })
}

// 修改监督检查-隐患分类分级标准
export function updateInfor(data) {
  return request({
    url: '/supervision/hideType',
    method: 'put',
    data: data
  })
}

// 删除监督检查-隐患分类分级标准
export function delInfor(fInsStaInforId) {
  return request({
    url: '/supervision/hideType/' + fInsStaInforId,
    method: 'delete'
  })
}

// 导出监督检查-隐患分类分级标准
export function exportInfor(query) {
  return request({
    url: '/supervision/hideType/export',
    method: 'get',
    params: query
  })
}

//所有隐患分类
export function hiddenList(query) {
  return request({
    url: '/supervision/hideType/hiddenList',
    method: 'get',
    params: query
  })
}
