import request from '@/utils/request'

// 查询特殊用户管控列表
export function listSpecialuser(query) {
  return request({
    url: '/supervise/specialuser/list',
    method: 'get',
    params: query
  })
}

// 查询特殊用户管控详细
export function getSpecialuser(specialId) {
  return request({
    url: '/supervise/specialuser/' + specialId,
    method: 'get'
  })
}

// 新增特殊用户管控
export function addSpecialuser(data) {
  return request({
    url: '/supervise/specialuser',
    method: 'post',
    data: data
  })
}

// 修改特殊用户管控
export function updateSpecialuser(data) {
  return request({
    url: '/supervise/specialuser',
    method: 'put',
    data: data
  })
}

// 删除特殊用户管控
export function delSpecialuser(specialId) {
  return request({
    url: '/supervise/specialuser/' + specialId,
    method: 'delete'
  })
}

// 导出特殊用户管控
export function exportSpecialuser(query) {
  return request({
    url: '/supervise/specialuser/export',
    method: 'get',
    params: query
  })
}