import request from '@/utils/request'

// 查询行业专家库-专家申报列表
export function listInfor(query) {
  return request({
    url: '/specialist/info/list',
    method: 'get',
    params: query
  })
}

// 查询行业专家库-专家申报详细
export function getInfor(fProAppInforId) {
  return request({
    url: '/specialist/info/' + fProAppInforId,
    method: 'get'
  })
}

// 新增行业专家库-专家申报
export function addInfor(data) {
  return request({
    url: '/specialist/info',
    method: 'post',
    data: data
  })
}

// 修改行业专家库-专家申报
export function updateInfor(data) {
  return request({
    url: '/specialist/info',
    method: 'put',
    data: data
  })
}

// 删除行业专家库-专家申报
export function delInfor(fProAppInforId) {
  return request({
    url: '/specialist/info/' + fProAppInforId,
    method: 'delete'
  })
}

// 导出行业专家库-专家申报
export function exportInfor(query) {
  return request({
    url: '/specialist/info/export',
    method: 'get',
    params: query
  })
}

//行业专家申报
export function reportProAppInfo(query) {
  return request({
    url: '/specialist/info/reportProAppInfo',
    method: 'get',
    params: query
  })
}
