import request from '@/utils/request'

// 查询管道信息列表
export function listPipe(query) {
  return request({
    url: '/supervise/pipe/list',
    method: 'get',
    params: query
  })
}

// 查询管道信息详细
export function getPipe(pipeId) {
  return request({
    url: '/supervise/pipe/' + pipeId,
    method: 'get'
  })
}

// 新增管道信息
export function addPipe(data) {
  return request({
    url: '/supervise/pipe',
    method: 'post',
    data: data
  })
}

// 修改管道信息
export function updatePipe(data) {
  return request({
    url: '/supervise/pipe',
    method: 'put',
    data: data
  })
}

// 删除管道信息
export function delPipe(pipeId) {
  return request({
    url: '/supervise/pipe/' + pipeId,
    method: 'delete'
  })
}

// 导出管道信息
export function exportPipe(query) {
  return request({
    url: '/supervise/pipe/export',
    method: 'get',
    params: query
  })
}

// 企业信息查询(下拉框)
export function selectTEnterprise() {
  return request({
    url: '/regulation/supervise/selectTEnterprise',
    method: 'get'
  })
}

