import request from '@/utils/request'

// 查询液化石油气-气瓶档案列表
export function listFiles(query) {
  return request({
    url: '/lpg/gasbottlefiles/list',
    method: 'get',
    params: query
  })
}

// 查询液化石油气-气瓶档案详细
export function getFiles(fGasBottleFilesId) {
  return request({
    url: '/lpg/gasbottlefiles/' + fGasBottleFilesId,
    method: 'get'
  })
}

// 新增液化石油气-气瓶档案
export function addFiles(data) {
  return request({
    url: '/lpg/gasbottlefiles',
    method: 'post',
    data: data
  })
}

// 修改液化石油气-气瓶档案
export function updateFiles(data) {
  return request({
    url: '/lpg/gasbottlefiles',
    method: 'put',
    data: data
  })
}

// 删除液化石油气-气瓶档案
export function delFiles(fGasBottleFilesId) {
  return request({
    url: '/lpg/gasbottlefiles/' + fGasBottleFilesId,
    method: 'delete'
  })
}

// 导出液化石油气-气瓶档案
export function exportFiles(query) {
  return request({
    url: '/lpg/gasbottlefiles/export',
    method: 'get',
    params: query
  })
}


// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/lpg/gasbottlefiles/importTemplate',
    method: 'get'
  })
}