import request from '@/utils/request'

// 查询从业人员信息列表
export function listInfo(query) {
  return request({
    url: '/practitioner/info/list',
    method: 'get',
    params: query
  })
}

export function practitionerInfoList(query) {
  return request({
    url: '/practitioner/info/practitionerInfoList',
    method: 'get',
    params: query
  })
}

// 查询从业人员信息详细
export function getInfo(practitionerId) {
  return request({
    url: '/practitioner/info/' + practitionerId,
    method: 'get'
  })
}

// 新增从业人员信息
export function addInfo(data) {
  return request({
    url: '/practitioner/info',
    method: 'post',
    data: data
  })
}

// 修改从业人员信息
export function updateInfo(data) {
  return request({
    url: '/practitioner/info',
    method: 'put',
    data: data
  })
}

// 删除从业人员信息
export function delInfo(practitionerId) {
  return request({
    url: '/practitioner/info/' + practitionerId,
    method: 'delete'
  })
}

// 导出从业人员信息
export function exportInfo(query) {
  return request({
    url: '/practitioner/info/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/practitioner/info/importTemplate',
    method: 'get'
  })
}
