import request from '@/utils/request'

// 查询充装记录列表
export function listRecord(query) {
  return request({
    url: '/charge/record/list',
    method: 'get',
    params: query
  })
}

// 查询充装记录详细
export function getRecord(chargeRecordId) {
  return request({
    url: '/charge/record/' + chargeRecordId,
    method: 'get'
  })
}

// 新增充装记录
export function addRecord(data) {
  return request({
    url: '/charge/record',
    method: 'post',
    data: data
  })
}

// 修改充装记录
export function updateRecord(data) {
  return request({
    url: '/charge/record',
    method: 'put',
    data: data
  })
}

// 删除充装记录
export function delRecord(chargeRecordId) {
  return request({
    url: '/charge/record/' + chargeRecordId,
    method: 'delete'
  })
}

// 导出充装记录
export function exportRecord(query) {
  return request({
    url: '/charge/record/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/charge/record/importTemplate',
    method: 'get'
  })
}


// 充装储配站统计
export function airChargeStationStatistics(query) {
  return request({
    url: '/charge/record/airChargeStationStatistics',
    method: 'get',
    params: query
  })
}

// 充装储配站统计导出
export function airChargeStationStatisticExport(query) {
  return request({
    url: '/charge/record/airChargeStationStatisticExport',
    method: 'get',
    params: query
  })
}

// 充装人员统计
export function airChargeOperatorStatistics(query) {
  return request({
    url: '/charge/record/airChargeOperatorStatistics',
    method: 'get',
    params: query
  })
}

// 充装人员统计导出
export function airChargeOperatorStatisticsExport(query) {
  return request({
    url: '/charge/record/airChargeOperatorStatisticsExport',
    method: 'get',
    params: query
  })
}
